<?php
/*
Plugin Name: Auto Login After Registration
Plugin URI: http://www.netattingo.com/
Description: This plugin allows users to easily add a simple user registration form and login form  anywhere on their site using simple shortcode.
And provide setting to 'Auto Login After Registration'. 
Author: NetAttingo Technologies
Version: 1.0.0
Author URI: http://www.netattingo.com/
*/

//define('WP_DEBUG',true );
define('ALAR_REGISTRATION_PAGE_DIRECTORY', plugin_dir_path(__FILE__) . 'pages/');
define('ALAR_REGISTRATION_INCLUDE_URL', plugin_dir_url(__FILE__) . 'includes/');
ob_start();
//Include menu
function alar_auto_login_plugin_menu()
{
    add_menu_page("Auto Login after Register", "Auto Login after Register", "administrator", "auto_login_on_register_setting", "alar_logo_plugin_pages", '', 40);
    add_submenu_page("auto_login_on_register_setting", "About Us", "About Us", "administrator", "about-us", "alar_logo_plugin_pages");
}

add_action("admin_menu", "alar_auto_login_plugin_menu");
function alar_logo_plugin_pages()
{
    $itm = ALAR_REGISTRATION_PAGE_DIRECTORY . $_GET["page"] . '.php';
    include($itm);
}

//add admin css
function alar_admin_css()
{
    wp_register_style('admin_css', plugins_url('includes/admin-style.css', __FILE__));
    wp_enqueue_style('admin_css');
}

add_action('admin_init', 'alar_admin_css');


//add front end css and js
function alar_slider_trigger()
{
//    wp_enqueue_style('alar_caro_css_and_js', ALAR_REGISTRATION_INCLUDE_URL . "front-style.css");
//    wp_register_script('alar_caro_css_and_js', ALAR_REGISTRATION_INCLUDE_URL . "font-script.js");
    wp_enqueue_script('alar_caro_css_and_js');
}

add_action('wp_footer', 'alar_slider_trigger');


/*=================================================*/
function _convert($content)
{
    if (!mb_check_encoding($content, 'UTF-8')
        or !($content === mb_convert_encoding(mb_convert_encoding($content, 'UTF-32', 'UTF-8'), 'UTF-8', 'UTF-32'))) {
        $content = mb_convert_encoding($content, 'UTF-8');
        if (mb_check_encoding($content, 'UTF-8')) {
            // log('Converted to UTF-8');
        } else {
            // log('Could not converted to UTF-8');
        }
    }
    return $content;
}

// function to registration Shortcode
function alar_registration_shortcode($atts)
{
    global $wpdb, $user_ID;
    $error_msg = ''; // Initialize error message variable
    $username = '';
    $firstname = '';
    $email = '';
    $usermobile = '';
    $userspecialty = '';
    //if looged in rediret to home page
    if (is_user_logged_in()) {
        wp_redirect(get_option('home'));// redirect to home page
        exit;
    }
    if (isset($_POST['com_submit'])) {

        $username = sanitize_text_field($_REQUEST['com_username']);
        $firstname = sanitize_text_field($_REQUEST['com_firstname']);
        $email = sanitize_text_field($_REQUEST['com_email']);
        $usermobile = sanitize_text_field($_REQUEST['user_mobile']);
        $user_mycitynow = sanitize_text_field($_REQUEST['user_mycitynow']);
      //  $userspecialty = sanitize_text_field($_REQUEST['user_specialty']);
        $password = $wpdb->escape(sanitize_text_field($_REQUEST['current_password']));
        $password2 = $wpdb->escape(sanitize_text_field($_REQUEST['current_password2']));
        $status = wp_create_user($username, $password, $email);
        if ($password != $password2) {
            $error_msg = __("كلمة المرور غير متطابقة", "m7md"); ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $error_msg; ?>
            </div>

        <?php } else {
            if (is_wp_error($status)) {
                $error_msg = __("اسم الدخول او البريد الالكتروني مسجل من قبل", "m7md");
                ?>
                <div class="alert alert-danger" role="alert">
                    <?php    echo $error_msg; ?>
                </div>
                <?php
            } else {
                $user_id = $status;
                update_user_meta($user_id, 'first_name', $firstname);
                update_user_meta($user_id, 'user_mobile', $usermobile);
                update_user_meta($user_id, 'user_mycitynow', $user_mycitynow);
          //      update_user_meta($user_id, 'user_specialty', $userspecialty);
                update_user_meta($user_id, 'user_status', 'active');
                update_user_meta($user_id, 'user_membership', 'member');

                //code to auto login start
                $alar_enable_auto_login = get_option('alar_enable_auto_login');
                if ($alar_enable_auto_login == '') {
                    $alar_enable_auto_login = 'true';
                }

                if ($alar_enable_auto_login == 'true') {
                    if (!is_user_logged_in()) {
                        $secure_cookie = is_ssl();
                        $secure_cookie = apply_filters('secure_signon_cookie', $secure_cookie, array());
                        global $auth_secure_cookie;
                        $auth_secure_cookie = $secure_cookie;
                        wp_set_auth_cookie($user_id, true, $secure_cookie);
                        $user_info = get_userdata($user_id);
                        do_action('wp_login', $user_info->user_login, $user_info);
                    }
                }
                //code to auto login end
                wp_redirect(get_option('home'));// redirect to home page
                exit;
            }
        }
    }
    ?>
    <div class="alar-registration-form">

        <?php if ($error_msg != '') : ?>
            <div class="error"><?php echo $error_msg; ?></div>
        <?php endif; ?>
        <form name="form"
              id="registration"
              method="post">


            <div class="form-group">
                <label for="com_username">
                    <?php _e("<!--:en--> * User Name<!--:--><!--:ar--> * إسم المستخدم<!--:-->"); ?>
                </label>
                <div class="alert alert-warning">
                    <strong>
                        <?php _e("<!--:en-->The name must be written in English without a space <!--:--><!--:ar--> يجب كتابة الاسم بالإنجليزي وبدون مسافة<!--:-->"); ?>
                    </strong>
                </div>

                <input id="com_username"
                       name="com_username"
                       type="text"
                       class="form-control"
                       required>
            </div>
            <div class="form-group">
                <label for="com_firstname">
                    <?php _e("<!--:en--> * The   name   <!--:--><!--:ar--> * الاسم الثنائي ( باللغة العربية ) <!--:-->"); ?>
                </label>
                <div class="alert alert-warning" role="alert">
                    <strong>
                        <?php _e("<!--:en--> The name must be written in accordance with official documents . <!--:--><!--:ar--> يجب كتابة الاسم الموافق للوثائق الرسمية . <!--:-->"); ?>
                    </strong>
                </div>
                <input id="com_firstname"
                       name="com_firstname"
                       type="text"
                       class="form-control"
                       required>
            </div>
            <div class="form-group">
                <label for="com_email">
                    <?php _e("<!--:en-->   Email <!--:--><!--:ar-->  البريد الإلكترونى <!--:-->"); ?>
                </label>
                <input id="com_email"
                       name="com_email"
                       type="email"
                       class="form-control"
                >
            </div>

<!-- الحقل المخفي الذي سيتم إرساله بالفعل -->
<input type="hidden" name="user_mycitynow" id="user_mycitynow_hidden" required>

<!-- حقل Select2 للواجهة فقط (بدون name) -->
<div class="form-group">
    <label for="country_selector_select2">
        <?php _e("<!--:en--> Nationality <!--:--><!--:ar-->  الجنسيه<!--:-->"); ?>
    </label>
    <select id="country_selector_select2" 
            class="form-control" 
            style="width: 100%;">
        <option></option>
    </select>
</div>


            <div class="form-group">
                <label for="telephone">
                    <?php _e("<!--:en-->* Phone Number <!--:--><!--:ar-->* رقم الجوال <!--:-->"); ?>
                </label>
                <input id="telephone"
                       name="user_mobile"
                       type="tel"
                       placeholder=""
                       class="form-control"
                       required>
            </div>

           <!-- <div class="form-group">
                <label for="user_mycitynow">
                    <?php _e("<!--:en--> Nationality <!--:--><!--:ar-->  الجنسيه<!--:-->"); ?>
                </label>
                <input id="user_mycitynow"
                       name="user_mycitynow"
                       type="text"
                       class="form-control"
                       required>
            </div>-->
            <!--
            <div class="form-group">
                <label for="user_specialty">
                    <?php _e(" * التخصص", "m7md"); ?>
                </label>
                <input id="user_specialty"
                       name="user_specialty"
                       type="text"
                       class="form-control"
                       required>
            </div>
-->
            <div class="form-group">
                <label for="password1">
                    <?php _e("<!--:en-->Password <!--:--><!--:ar-->كلمة المرور <!--:-->"); ?>
                </label>
                <input id="password1"
                       name="current_password"
                       type="password"
                       required
                       class="form-control"/>
            </div>
            <div class="form-group">
                <label for="password2">
                    <?php _e("<!--:en--> Confirm Password<!--:--><!--:ar--> تاكيد كلمة المرور <!--:-->"); ?>
                </label>
                <input id="password2"
                       name="current_password2"
                       type="password"
                       class="form-control"/>
            </div>
            <div class="check-rules">
                <input type="checkbox" id="rules" name="rules">
                <label for="rules">
                    <a href="<?php echo esc_url( get_page_link( 20139 ) ); ?>" target="_blank">
                        <?php _e("<!--:en--> Agree to the terms and conditions<!--:--><!--:ar--> الموافقة علي الشروط و الأحكام<!--:-->"); ?>
                    </a>
                </label>
            </div>
            <div class="text-center">

                <button type="submit"
                        class='main-button dis-but'
                        name='com_submit'>
                    <span> <?php _e("<!--:en-->Register <!--:--><!--:ar-->تسجيل <!--:-->"); ?></span>

                    <?php the_switch_language('<i class="fa-solid fa-arrow-left-long"></i>',
                        '<i class="fa-solid fa-arrow-right-long"></i>') ?>
                </button>


            </div>
        </form>
    </div>
    <?php
}

//add registration shortcode
add_shortcode('registration-form', 'alar_registration_shortcode');
/*=================================================*/
// function to registration Shortcode
function alar_registration_instructor_shortcode($atts)
{
    global $wpdb, $user_ID;
    $error_msg = ''; // Initialize error message variable
    $username = '';
    $firstname = '';
    $email = '';
    $usermobile = '';
    $userspecialty = '';
    $userClassificationNum = '';
    $userjob = '';
    //if looged in rediret to home page
    if (is_user_logged_in()) {
        wp_redirect(get_option('home'));// redirect to home page
        exit;
    }
    if (isset($_POST['com_submit'])) {

        $username = sanitize_text_field($_REQUEST['com_username']);
        $firstname = sanitize_text_field($_REQUEST['com_firstname']);
        $email = sanitize_text_field($_REQUEST['com_email']);
        $usermobile = sanitize_text_field($_REQUEST['user_mobile']);
        $user_mycitynow = sanitize_text_field($_REQUEST['user_mycitynow']);
      //  $userspecialty = sanitize_text_field($_REQUEST['user_specialty']);
        $userClassificationNum = sanitize_text_field($_REQUEST['user_classificationNum']);
        $user_member_type = sanitize_text_field($_REQUEST['user_member_type']);
        $userjob = sanitize_text_field($_REQUEST['user_job']);
        $password = $wpdb->escape(sanitize_text_field($_REQUEST['current_password']));
        $password2 = $wpdb->escape(sanitize_text_field($_REQUEST['current_password2']));
        $status = wp_create_user($username, $password, $email);
        if ($password != $password2) {
            $error_msg = __("كلمة المرور غير متطابقة", "m7md"); ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $error_msg; ?>
            </div>

        <?php } else {
            if (is_wp_error($status)) {
                $error_msg = __("<!--:en--> Login name or email is already registered <!--:--><!--:ar--> اسم الدخول او البريد الالكتروني مسجل من قبل<!--:-->");?>
                <div class="alert alert-danger" role="alert">
                    <?php    echo $error_msg; ?>
                </div>
                <?php
            } else {
                $user_id = $status;
                update_user_meta($user_id, 'first_name', $firstname);
                update_user_meta($user_id, 'user_mobile', $usermobile);
                update_user_meta($user_id, 'user_mycitynow', $user_mycitynow);
        //        update_user_meta($user_id, 'user_specialty', $userspecialty);
                update_user_meta($user_id, 'user_classificationNum', $userClassificationNum);
                update_user_meta($user_id, 'user_member_type', $user_member_type);
                update_user_meta($user_id, 'user_job', $userjob);
                update_user_meta($user_id, 'user_status', 'active');
                update_user_meta($user_id, 'user_membership', 'instructor');

                //code to auto login start
                $alar_enable_auto_login = get_option('alar_enable_auto_login');
                if ($alar_enable_auto_login == '') {
                    $alar_enable_auto_login = 'true';
                }

                if ($alar_enable_auto_login == 'true') {
                    if (!is_user_logged_in()) {
                        $secure_cookie = is_ssl();
                        $secure_cookie = apply_filters('secure_signon_cookie', $secure_cookie, array());
                        global $auth_secure_cookie;
                        $auth_secure_cookie = $secure_cookie;
                        wp_set_auth_cookie($user_id, true, $secure_cookie);
                        $user_info = get_userdata($user_id);
                        do_action('wp_login', $user_info->user_login, $user_info);
                    }
                }
                //code to auto login end
                wp_redirect(get_option('home'));// redirect to home page
                exit;
            }
        }
    }
    ?>
    <div class="alar-registration-form">

        <?php if ($error_msg != '') : ?>
            <div class="error"><?php echo $error_msg; ?></div>
        <?php endif; ?>
        <form name="form"
              id="registration"
              method="post">



            <div class="form-group">
                <label for="com_username">
                    <?php _e(" * إسم المستخدم", "m7md"); ?>
                </label>
                <div class="alert alert-warning">
                    <strong>
                        <?php _e("يجب كتابة الاسم بالإنجليزي وبدون مسافة ", "m7md"); ?>
                    </strong>
                </div>
                <input id="com_username"
                       name="com_username"
                       type="text"
                       class="form-control"
                       required>
            </div>
            <div class="form-group">
                <label for="com_firstname">
                    <?php _e(" * الاسم الثنائي ( باللغة العربية )", "m7md"); ?>
                </label>
                <div class="alert alert-warning" role="alert">
                    <strong>
                        <?php _e("يجب كتابة الاسم الموافق للوثائق الرسمية  .", "m7md"); ?>
                    </strong>
                </div>
                <input id="com_firstname"
                       name="com_firstname"
                       type="text"
                       class="form-control"
                       required>
            </div>
            <div class="form-group">
                <label for="com_email">
                    <?php _e(" * البريد الإلكترونى", "m7md"); ?>
                </label>
                <input id="com_email"
                       name="com_email"
                       type="email"
                       class="form-control"
                       required>
            </div>
            <div class="form-group">
                <label for="telephone">
                    <?php _e(" * رقم الجوال *", "m7md"); ?>
                </label>
                <input id="telephone"
                       name="user_mobile"
                       type="tel"
                       placeholder=""
                       class="form-control"
                       required>
            </div>

            <!--      <div class="form-group">
                <label for="user_specialty">
                    <?php _e(" * التخصص", "m7md"); ?>
                </label>
                <input id="user_specialty"
                       name="user_specialty"
                       type="text"
                       class="form-control"
                       required>
            </div>
-->
            <div class="form-group">
                <label for="user_site">
                    <?php _e("رقم التصنيف ان وجد", "m7md"); ?>
                </label>
                <input id="user_site"
                       name="user_classificationNum"
                       type="text"
                       class="form-control">
            </div>
            <div class="form-group">
                <div class="col-form-label">
                    <?php _e("هل لديك عضوية (سارية) في الجمعية", "m7md"); ?>
                </div>
                <div class="custom-control custom-radio">
                    <input type="radio"
                           class="custom-control-input"
                           id="user_member_talented"
                           name="user_member_type"
                           value="عضوية عاملة"
                           required>
                    <label class="custom-control-label"
                           for="user_member_talented">
                        <?php _e("نعم، عضوية عاملة", "m7md"); ?>
                    </label>
                </div>
                <div class="custom-control custom-radio">
                    <input type="radio"
                           class="custom-control-input"
                           id="user_member_kids"
                           name="user_member_type"
                           value="عضوية انتساب"
                           required>
                    <label class="custom-control-label"
                           for="user_member_kids">
                        <?php _e("نعم، عضوية انتساب", "m7md"); ?>
                    </label>
                </div>
                <div class="custom-control custom-radio">
                    <input type="radio"
                           class="custom-control-input"
                           id="user_member_others"
                           name="user_member_type"
                           value="لست عضو بالجمعية"
                           required>
                    <label class="custom-control-label"
                           for="user_member_others">
                        <?php _e("لست عضو بالجمعية", "m7md"); ?>
                    </label>
                </div>
            </div>
            <div class="form-group">
                <label for="job">
                    <?php _e("جهه العمل (ان وجد)", "m7md"); ?>
                </label>
                <input id="job"
                       name="user_job"
                       type="text"
                       placeholder=""
                       class="form-control">
            </div>
            <div class="form-group">
                <label for="password1">
                    <?php _e("كلمة المرور", "m7md"); ?>
                </label>
                <input id="password1"
                       name="current_password"
                       type="password"
                       required
                       class="form-control"/>
            </div>
            <div class="form-group">
                <label for="password2">
                    <?php _e("تاكيد كلمة المرور", "m7md"); ?>
                </label>
                <input id="password2"
                       name="current_password2"
                       type="password"
                       class="form-control"/>
            </div>
            <div class="check-rules">
                <input type="checkbox" id="rules" name="rules">
                <label for="rules">
                    <a href="<?php echo esc_url( get_page_link( 20139 ) ); ?>" target="_blank">
                        <?php _e("<!--:en--> Agree to the terms and conditions<!--:--><!--:ar--> الموافقة علي الشروط و الأحكام<!--:-->"); ?>
                    </a>
                </label>
            </div>
            <div class="text-center">
                <button type="submit"
                        class='main-button dis-but'
                        name='com_submit'>
                    <span><?php _e('تسجيل', 'm7md') ?></span>

                    <?php the_switch_language('<i class="fa-solid fa-arrow-left-long"></i>',
                        '<i class="fa-solid fa-arrow-right-long"></i>') ?>
                </button>


            </div>
        </form>
    </div>
    <?php
}

//add registration shortcode
add_shortcode('registration-instructor-form', 'alar_registration_instructor_shortcode');
/*=================================================*/
// function to login Shortcode
function alar_login_shortcode($atts)
{
    //if looged in rediret to home page
    if (is_user_logged_in()) {
        wp_redirect(get_option('home'));// redirect to home page
        exit;
    }

    global $wpdb;
    $login_fail_msg = ''; // Initialize login fail message variable
    if (isset($_GET['login']) && $_GET['login'] != '') {
        $login_fail_msg = sanitize_text_field($_GET['login']);
    }
    ?>
    <div class="login-form">
        <?php if ($login_fail_msg == 'failed') : ?>
            <div class="alert alert-danger">
                <?php _e("<!--:en--> Username or password is incorrect<!--:--><!--:ar-->إسم المستخدم أو كلمة المرور غير صحيحة <!--:-->"); ?>

            </div>
        <?php endif; ?>
        <form method="post"
              action="<?php echo get_option('home'); ?>/wp-login.php">
            <div class="form-group">
                <label for="user_login">
                    <?php _e("<!--:en-->Username or Email Address <!--:--><!--:ar-->اسم المستخدم أو البريد الإلكترونى <!--:-->"); ?>
                </label>
                <input type="text"
                       class="form-control"
                       id="user_login"
                       required
                       name="log"/>
            </div>
            <div class="form-group">
                <label for="user_pass">
                    <?php _e("<!--:en-->Password <!--:--><!--:ar--> كلمة المرور<!--:-->"); ?>
                </label>
                <input type="password"
                       class="form-control"
                       id="user_pass"
                       required
                       name="pwd"/>
            </div>
            <div class="d-flex align-items-center justify-content-between">


                <button type="submit"
                        class='main-button'
                        name='wp-submi'>
                    <span><?php _e("<!--:en-->Login <!--:--><!--:ar-->دخول <!--:-->"); ?> </span>

                    <?php the_switch_language('<i class="fa-solid fa-arrow-left-long"></i>',
                        '<i class="fa-solid fa-arrow-right-long"></i>') ?>
                </button>


                <a class="forget-btn"
                   href="<?php echo get_page_link(86); ?>">
                    <?php _e("<!--:en--> Restore password<!--:--><!--:ar-->إستعادة كلمة المرور <!--:-->"); ?>
                </a>
            </div>
            <input type="hidden"
                   value="<?php echo get_option('home'); ?>"
                   name="redirect_to">
        </form>
    </div>
    <?php
}

//add login shortcoode
add_shortcode('login-form', 'alar_login_shortcode');


//redirect to front end ,when login is failed
add_action('wp_login_failed', 'my_front_end_login_fail');  // hook failed login

function my_front_end_login_fail($username)
{
    $referrer = $_SERVER['HTTP_REFERER'];
    // if there's a valid referrer, and it's not the default log-in screen
    if (!empty($referrer) && !strstr($referrer, 'wp-login') && !strstr($referrer, 'wp-admin')) {
        wp_redirect($referrer . '/?login=failed');  // let's append some information (login=failed) to the URL for the theme to use
        exit;
    }
}

?>
