<?php get_header(); ?>

<section class="mainsingle">
    <div class="container">
        <?php if (have_posts()) { ?>
        <div class="row">
            <?php $servdelay = .2 ; while (have_posts()) : the_post(); ?>
                <div class="col-md-4">
                    <div class="serviceitem wow fadeInUp" data-wow-delay= '<?php echo $servdelay ?>s' >
                        <a href="<?php the_permalink(); ?>">
                            <div class="topserviceitem">
                                <h4><?php the_title() ?></h4>
                                <?php
                                $imageserv = get_field('iconservice');
                                if ($imageserv) {
                                    $imgserv_url   = $imageserv['url'];
                                    $imgserv_title = $imageserv['title'];
                                    $imgserv_alt   = $imageserv['alt'];
                                    if (empty($imgserv_alt)) {
                                        $imgserv_alt = $imgserv_title;
                                    }
                                }
                                ?>

                                <img class="img-fluid"
                                     src="<?php echo esc_url($imgserv_url); ?>"
                                     alt="<?php echo esc_attr($imgserv_alt); ?>"
                                     title="<?php echo esc_attr($imgserv_title); ?>" />
                            </div>
                            <div class="bottomserviceitem">
                                <?php the_excerpt(); ?>
                                <?php
                                $thumbnailser_id = get_post_thumbnail_id();
                                $titleser = get_the_title($thumbnailser_id);
                                $altser = get_post_meta($thumbnailser_id, '_wp_attachment_image_alt', true) ?: $titleser ;
                                ?>
                                <img src="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>"
                                     class="img-fluid"
                                     alt="<?php echo esc_attr($altser); ?>"
                                     title="<?php echo esc_attr($titleser); ?>" />
                            </div>
                        </a>
                    </div>
                </div>
                <?php $servdelay+=.2;  endwhile; ?>
            <div class="col-12 d-flex justify-content-center">
                <?php
                wp_paginate()
                ?>
            </div>

        </div>
        <?php } else { ?>
            <h3>
                <?php  _e("<!--:en--> No Items Found <!--:--><!--:ar--> لا توجد عناصر حاليا  <!--:-->"); ?>
            </h3>
        <?php } ?>
    </div>
</section>





<?php get_footer(); ?>
