<?php get_header(); ?>

<section class="mainsingle">
    
       
        
 <?php 
 

$ajax_nonce = wp_create_nonce( 'vessels_ajax_nonce' );
$taxonomy_name = 'vesselss_taxonomy';
$post_type = 'vessels';

// جلب الأقسام الرئيسية
$top_terms = get_terms( array(
    'taxonomy'   => $taxonomy_name,
    'parent'     => 0,
    'hide_empty' => true,
    'orderby'    => 'name',
    'order'      => 'ASC',
) );
?>
    <!-- شريط الأقسام -->
    <?php if ( !empty($top_terms) && !is_wp_error($top_terms) ) : ?>
        <div class="row mb-5">
            <div class="col-12">
                <ul class="taxcatvells" id="vessels-tabs">
                    <?php foreach ( $top_terms as $index => $t ) : 
                        $is_active = ( $index === 0 ) ? 'active  ' : ' ';
                    ?>
                        <li class="nav-item">
                            <a class="  <?php echo esc_attr($is_active); ?>   term-tab"
                               href="#" 
                               data-term-id="<?php echo esc_attr($t->term_id); ?>">
                                <?php echo esc_html($t->name); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    <?php endif; ?>
<div class="container">

    <!-- مكان الصورة + العنوان الصغير + الوصف -->



    <div id="term-header">
        <!-- هيتم ملؤه بـ AJAX -->
    </div>
    <!-- المحتوى -->
    <div id="vessels-content">
        <!-- هيتم ملؤه بـ AJAX أول مرة -->
        <div class="text-center py-5">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden"></span>
            </div>
        </div>
    </div>

</div>

 <script type="text/javascript">
jQuery(document).ready(function($) {
    loadFirstTerm(); // تحميل الأول
    
    function loadFirstTerm() {
        if ($('.term-tab').length > 0) {
            var firstTermId = $('.term-tab:first').data('term-id');
            loadTermContent(firstTermId);
        }
    }
    
    $('.term-tab').on('click', function(e) {
        e.preventDefault();
        var $this = $(this);
        var termId = $this.data('term-id');
        
        // Active class
        $('.term-tab').removeClass('active  ') 
        $this.addClass('active  ');
        
        loadTermContent(termId);
    });
    
    function loadTermContent(termId) {
        // Loading
         $('#term-header').html('<div class="text-center py-3 hide"><div class="spinner-border spinner-border-sm text-primary " role="status"></div></div>');
        $('#vessels-content').html('<div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden"> </span></div></div>');
        
        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>',
            type: 'POST',
            dataType: 'json', // مهم جداً!
            data: {
                action: 'load_vessels_by_term',
                term_id: termId,
                nonce: '<?php echo $ajax_nonce; ?>'
            },
            success: function(response) {
                if (response.success) {
                    $('#term-header').html(response.data.header);
                    $('#vessels-content').html(response.data.content);
                } else {
                    $('#term-header').html('<div class="alert alert-danger text-center">' + response.data + '</div>');
                    $('#vessels-content').html('<div class="alert alert-danger text-center">خطأ في تحميل العناصر</div>');
                }
            },
            error: function(xhr, status, error) {
                console.log('AJAX Error:', error);
                $('#term-header').html('<div class="alert alert-danger text-center">خطأ في الاتصال</div>');
                $('#vessels-content').html('<div class="alert alert-danger text-center">خطأ في تحميل العناصر</div>');
            }
        });
    }
});
</script>


 


        
        
        
        
        
        
        
        
        
 
</section>





<?php get_footer(); ?>
