<?php get_header(); ?>

<!-- Start Slider -->
<?php
$args = array(
    'post_type' => 'slider',
    'posts_per_page' => 6,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) {
?>


    <section class="mainslider-sec">
        <div class="owl-carousel main-slider">
            <?php while ($loop->have_posts()) : $loop->the_post(); ?>
                <div class="mainslider-item">
                    <?php
                    $thumbnail_id = get_post_thumbnail_id();
                    $title = get_the_title($thumbnail_id);
                    $alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true) ?: $title ;
                    ?>
                    <img src="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>"
                            class="img-fluid"
                            alt="<?php echo esc_attr($alt); ?>"
                            title="<?php echo esc_attr($title); ?>" />


                        <div class="onimagemainslider-item">
                            <h3><?php  the_title() ?></h3>
                            <?php the_excerpt(); ?>
                            <div class="mainallslide">
                                <a class="main-buttonsc" href="<?php get_field('add_external_link') ? the_field('button_link_slider') : the_permalink(); ?>">
                                <span>
                                    <?php
                                    if ( get_field('add_external_link') == true){
                                        the_field('button_text_slider');
                                    }else{
                                        _e("<!--:en--> Read More<!--:--><!--:ar--> اقرأ المزيد <!--:-->");
                                    }
                                    ?>
                                </span>
                                    <div class="iconbtnmain">
                                        <i class="fa-solid fa-arrow-up"></i>
                                    </div>
                                </a>
                            </div>
                        </div>


                </div>
            <?php endwhile; ?>
        </div>
    </section>



<?php }
wp_reset_postdata(); ?>


<!-- End Slider -->


<!-- Start About -->

<section class="aboutsec">

        <div class="aboutsecimg wow fadeIn">
            <?php
            $imageabout = get_field('the_image_about', 'option');
            if ($imageabout) {
                $imgabout_url   = $imageabout['url'];
                $imgabout_title = $imageabout['title'];
                $imgabout_alt   = $imageabout['alt'];
                if (empty($imgabout_alt)) {
                    $imgabout_alt = $imgabout_title;
                }
            }
            ?>

            <img class="img-fluid"
                 src="<?php echo esc_url($imgabout_url); ?>"
                 alt="<?php echo esc_attr($imgabout_alt); ?>"
                 title="<?php echo esc_attr($imgabout_title); ?>" />

        </div>
            <div class="aboutsectxt">
                <h2 class="mainwheader wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInRight' : 'fadeInLeft'; ?>">
                    <span><?php _e("<!--:en-->About <!--:--><!--:ar-->من  <!--:-->"); ?></span>
                    <span><?php _e("<!--:en--> Us <!--:--><!--:ar--> نحن<!--:-->"); ?></span>
                </h2>
                <div class="wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInUp' : 'fadeInUp'; ?>"
                     data-wow-delay= '.2s' >
                    <?php the_field('the_description_about','option'); ?>
                </div>
                <a class="main-buttonsc wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInUp' : 'fadeInUp'; ?>"
                   href="<?php the_field('link_button_about','option'); ?>" data-wow-delay= '.4s' >
                                <span>
                                    <?php
                                        _e("<!--:en--> Read More<!--:--><!--:ar--> اقرأ المزيد <!--:-->");
                                    ?>
                                </span>
                    <div class="iconbtnmain">
                        <i class="fa-solid fa-arrow-up"></i>
                    </div>
                </a>
            </div>





</section>

<!-- End About -->


<!-- Start services -->
<?php
$args = array(
    'post_type' => 'service',
    'posts_per_page' => 5,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) {
?>
<section class="servicessec">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <div class="titleservsrs">
                    <img class="img-fluid wow fadeInUp" src="<?php echo THEME_IMAGES_DIR . 'bosla.png'; ?>" title="service" alt="service">
                    <h2 class="mainwheader wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInRight' : 'fadeInLeft'; ?>">
                        <span><?php _e("<!--:en-->Our <!--:--><!--:ar-->خدما  <!--:-->"); ?></span>

                        <span><?php _e("<!--:en--> Service <!--:--><!--:ar--> تنا<!--:-->"); ?></span>
                    </h2>
                    <p class="wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInRight' : 'fadeInLeft'; ?>">
                        <?php _e("<!--:en--> we are innovative & also creative <!--:--><!--:ar-->نحن مبتكرون ومبدعون أيضاً<!--:-->"); ?>
                    </p>
                </div>
            </div>
            <?php $servdelay = .2 ; while ($loop->have_posts()) : $loop->the_post(); ?>
            <div class="col-md-4">
                <div class="serviceitem wow fadeInUp" data-wow-delay= '<?php echo $servdelay ?>s' >
                    <a href="<?php the_permalink(); ?>">
                        <div class="topserviceitem">
                            <h4><?php the_title() ?></h4>
                            <?php
                            $imageserv = get_field('iconservice');
                            if ($imageserv) {
                                $imgserv_url   = $imageserv['url'];
                                $imgserv_title = $imageserv['title'];
                                $imgserv_alt   = $imageserv['alt'];
                                if (empty($imgserv_alt)) {
                                    $imgserv_alt = $imgserv_title;
                                }
                            }
                            ?>

                            <img class="img-fluid"
                                 src="<?php echo esc_url($imgserv_url); ?>"
                                 alt="<?php echo esc_attr($imgserv_alt); ?>"
                                 title="<?php echo esc_attr($imgserv_title); ?>" />
                        </div>
                        <div class="bottomserviceitem">
                            <?php the_excerpt(); ?>
                            <?php
                            $thumbnailser_id = get_post_thumbnail_id();
                            $titleser = get_the_title($thumbnailser_id);
                            $altser = get_post_meta($thumbnailser_id, '_wp_attachment_image_alt', true) ?: $titleser ;
                            ?>
                            <img src="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>"
                                 class="img-fluid"
                                 alt="<?php echo esc_attr($altser); ?>"
                                 title="<?php echo esc_attr($titleser); ?>" />
                        </div>
                    </a>
                </div>
            </div>
            <?php $servdelay+=.2;  endwhile; ?>

        </div>
    </div>
</section>
<?php }
wp_reset_postdata(); ?>
<!-- End services -->


<!-- start numbers -->
<?php
if(get_field('ournumbers','option')): ?>
<section class="numverssec">
    <div class="container">
        <div class="row justify-content-center">
            <?php  $i = 0; $umnes= .2; while(has_sub_field('ournumbers','option')):
                $i++;
                ?>

            <div class="col-md-3 col-6">
                <div class="numberitme wow fadeInUp" data-wow-delay= '<?php echo $umnes ?>s' >
                    <div class="numberitmeimg">
                        <img class="img-fluid wow fadeInUp" src="<?php echo THEME_IMAGES_DIR . 'numaf.png'; ?>" title="numbers" alt="numbers">
                    </div>
                    <h3>
                        <span><?php the_sub_field('the_number_number','option') ?></span>
                        <?php if ($i <= 3) : ?>
                            K
                        <?php endif; ?>

                    </h3>
                    <p>
                        <?php the_sub_field('the_title_number','option') ?>
                    </p>
                </div>
            </div>
            <?php $umnes+= .2; endwhile; ?>
        </div>
    </div>
</section>
<?php endif; ?>
<!-- End numbers -->

<!-- Start  vessels -->


<?php
$args = array(
    'post_type' => 'vessels',
    'posts_per_page' => 12,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) {
?>
<section class="projectsec">
    <div class="container">
        <div class="header-btn">
            <h2 class="mainwheader wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInRight' : 'fadeInLeft'; ?>">
                <span><?php _e("<!--:en-->Vess <!--:--><!--:ar-->السفن  <!--:-->"); ?></span>

                <span><?php _e("<!--:en--> els <!--:--><!--:ar--> <!--:-->"); ?></span>
            </h2>
            <a class="main-buttonsc wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInUp' : 'fadeInUp'; ?>"
               href="<?php echo get_post_type_archive_link( 'projects' ); ?>" data-wow-delay= '.4s' >
                                <span>
                                    <?php
                                    _e("<!--:en--> Read More<!--:--><!--:ar--> اقرأ المزيد <!--:-->");
                                    ?>
                                </span>
                <div class="iconbtnmain">
                    <i class="fa-solid fa-arrow-up"></i>
                </div>
            </a>
        </div>
    </div>
    <div class="owl-carousel projects-slider">
            <?php while ($loop->have_posts()) : $loop->the_post(); ?>
            <div class="projectitm">
                <?php
                $thumbnailproj_id = get_post_thumbnail_id();
                $titleproj = get_the_title($thumbnailproj_id);
                $altproj = get_post_meta($thumbnailproj_id, '_wp_attachment_image_alt', true) ?: $titleproj ;
                ?>
                <img src="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>"
                     class="img-fluid"
                     alt="<?php echo esc_attr($altproj); ?>"
                     title="<?php echo esc_attr($titleproj); ?>" />
                <div class="onprojitm">
                    <h3><?php the_title() ?></h3>
                    <?php the_excerpt(); ?>
                    <a class="main-buttonsc "
                       href="<?php the_permalink(); ?>"  >
                                <span>
                                    <?php
                                    _e("<!--:en--> Read More<!--:--><!--:ar--> اقرأ المزيد <!--:-->");
                                    ?>
                                </span>
                        <div class="iconbtnmain">
                            <i class="fa-solid fa-arrow-up"></i>
                        </div>
                    </a>
                </div>
            </div>
            <?php endwhile; ?>
        </div>

</section>
<?php }
wp_reset_postdata(); ?>


<!-- end  Projects -->

<!-- Start  exhibition -->
<?php
$args = array(
    'post_type' => 'exhibition',
    'posts_per_page' => 18,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) {
?>
<section class="exhibitionsec">
    <div class="container">
        <div class="header-btn">
            <h2 class="mainwheader wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInRight' : 'fadeInLeft'; ?>">
                <span><?php _e("<!--:en-->Ex <!--:--><!--:ar-->المعر  <!--:-->"); ?></span>

                <span><?php _e("<!--:en--> hibition <!--:--><!--:ar--> ض<!--:-->"); ?></span>
            </h2>
            <ul class="nav nav-tabs " id="myTab" role="tablist">
                <li class="nav-item wow fadeInUp" role="presentation" data-wow-delay= '.2s' >
                    <button class="nav-link active" id="video-tab" data-toggle="tab" data-target="#vids" type="button" role="tab" aria-controls="vids" aria-selected="false">
                        <?php _e("<!--:en--> Videos <!--:--><!--:ar-->الفيديوهات  <!--:-->"); ?>
                    </button>
                </li>

                <li class="nav-item wow fadeInUp" role="presentation" data-wow-delay= '.3s'>
                    <button class="nav-link " id="image-tab" data-toggle="tab" data-target="#imgs" type="button" role="tab" aria-controls="imgs" aria-selected="true">
                        <?php _e("<!--:en--> Pictures <!--:--><!--:ar-->الصور <!--:-->"); ?>
                    </button>
                </li>

            </ul>
        </div>
        <div class="tab-content" id="myTabContent">

            <!-- ================== محتوى تاب الفيديوهات ================== -->
            <div class="tab-pane fade show active" id="vids" role="tabpanel" aria-labelledby="video-tab">
                <div class="gallery-container"> <!-- حاوية لتنظيم العناصر -->
                    <?php
                    // نسخة جديدة من الحلقة لجلب الفيديوهات فقط
                    $videos_loop = new WP_Query($loop->query_vars);
                    while ($videos_loop->have_posts()) : $videos_loop->the_post();
                        // تحقق إذا كان المنشور يحتوي على فيديو
                        if (get_field('check_videadded')) {
                            $video_url = get_field('videocheckedyes');
                            $thumbnail_url = get_the_post_thumbnail_url(null, 'full');
                            $thumbnailexhi_id = get_post_thumbnail_id();
                            $titleexhi = get_the_title($thumbnailexhi_id);
                            $altexhi = get_post_meta($thumbnailexhi_id, '_wp_attachment_image_alt', true) ?: $titleexhi;
                            ?>
                            <div class="gallery-item">
                                <img src="<?php echo esc_url($thumbnail_url); ?>" class="img-fluid" alt="<?php echo esc_attr($altexhi); ?>" title="<?php echo esc_attr($titleexhi); ?>" />
                                <a href="<?php echo esc_url($video_url); ?>" data-fancybox="videos-gallery">
                                    <i class="fa-solid fa-play"></i> <!-- أيقونة تشغيل للفيديو -->
                                </a>
                            </div>
                            <?php
                        } // نهاية التحقق من الفيديو
                    endwhile;
                    wp_reset_postdata(); // إعادة تعيين بيانات المنشور
                    ?>
                </div>
            </div>

            <!-- ================== محتوى تاب الصور ================== -->
            <div class="tab-pane fade" id="imgs" role="tabpanel" aria-labelledby="image-tab">
                <div class="gallery-container"> <!-- حاوية لتنظيم العناصر -->
                    <?php
                    // نسخة جديدة من الحلقة لجلب الصور فقط
                    $images_loop = new WP_Query($loop->query_vars);
                    while ($images_loop->have_posts()) : $images_loop->the_post();
                        // تحقق إذا كان المنشور لا يحتوي على فيديو (أي أنه صورة)
                        if (!get_field('check_videadded')) {
                            $image_url = get_the_post_thumbnail_url(null, 'full');
                            $thumbnailexhi_id = get_post_thumbnail_id();
                            $titleexhi = get_the_title($thumbnailexhi_id);
                            $altexhi = get_post_meta($thumbnailexhi_id, '_wp_attachment_image_alt', true) ?: $titleexhi;
                            ?>
                            <div class="gallery-item">
                                <img src="<?php echo esc_url($image_url); ?>" class="img-fluid" alt="<?php echo esc_attr($altexhi); ?>" title="<?php echo esc_attr($titleexhi); ?>" />
                                <a href="<?php echo esc_url($image_url); ?>" data-fancybox="images-gallery">
                                    <i class="fa-solid fa-circle-plus"></i>
                                </a>
                            </div>
                            <?php
                        } // نهاية التحقق من الصورة
                    endwhile;
                    wp_reset_postdata(); // إعادة تعيين بيانات المنشور
                    ?>
                </div>
            </div>

        </div>

    </div>
</section>
<?php }
wp_reset_postdata(); ?>
<!-- End  exhibition -->

<!-- Start News -->
<?php
$args = array(
    'post_type' => 'news',
    'posts_per_page' => 3,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) {
?>
<section class="newsec">
    <div class="container">
        <h2 class="mainwheader wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInRight' : 'fadeInLeft'; ?>">
            <span><?php _e("<!--:en-->N <!--:--><!--:ar-->أخبا  <!--:-->"); ?></span>

            <span><?php _e("<!--:en--> ews <!--:--><!--:ar--> رنا<!--:-->"); ?></span>
        </h2>
        <div class="allcontentnews">
            <div class="row ">
                <?php $newsitm =.2; while ($loop->have_posts()) : $loop->the_post(); ?>
                    <div class="col-md-4">
                        <div class="newsitm wow fadeInUp" data-wow-delay= '<?php echo $newsitm ?>s'>
                            <div class="imgsecitm">
                                <?php
                                $thumbnailnews_id = get_post_thumbnail_id();
                                $titlenews = get_the_title($thumbnailnews_id);
                                $altnews = get_post_meta($thumbnailnews_id, '_wp_attachment_image_alt', true) ?: $titlenews ;
                                ?>
                                <img src="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>"
                                     class="img-fluid"
                                     alt="<?php echo esc_attr($altnews); ?>"
                                     title="<?php echo esc_attr($titlenews); ?>" />
                                <div class="onimgsecitm">
                                    <i class="fa-solid fa-calendar-days"></i>
                                     <span><?php echo get_the_date('d-m-Y'); ?></span>
                                 </div>
                            </div>
                            <div class="txtsecitm">
                                <h3><?php the_title() ?></h3>
                                <?php the_excerpt(); ?>
                                <a class="main-buttonsc "
                                   href="<?php the_permalink(); ?>"  >
                                <span>
                                    <?php
                                    _e("<!--:en--> Read More<!--:--><!--:ar--> اقرأ المزيد <!--:-->");
                                    ?>
                                </span>
                                    <div class="iconbtnmain">
                                        <i class="fa-solid fa-arrow-up"></i>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php  $newsitm+=.2; endwhile; ?>
            </div>
        </div>
    </div>
</section>
<?php }
wp_reset_postdata(); ?>
<!-- End News -->

<!-- Start Clints -->

<?php
$args = array(
    'post_type' => 'clients',
    'posts_per_page' => 12,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) {
?>
<section class="clintssec">
    <div class="container">
        <div class="header-btn">
            <h2 class="mainwheader wow <?php echo ( qtranxf_getLanguage() == 'ar' ) ? 'fadeInRight' : 'fadeInLeft'; ?>">
                <span><?php _e("<!--:en-->Our <!--:--><!--:ar-->عملا  <!--:-->"); ?></span>

                <span><?php _e("<!--:en--> Clients <!--:--><!--:ar--> ئنا<!--:-->"); ?></span>
            </h2>
        </div>
        <div class="owl-carousel clints-slider">
            <?php while ($loop->have_posts()) : $loop->the_post(); ?>
            <div class="clintitm">
                <?php
                $thumbnailclints_id = get_post_thumbnail_id();
                $titleclints = get_the_title($thumbnailclints_id);
                $altclints = get_post_meta($thumbnailclints_id, '_wp_attachment_image_alt', true) ?: $titleclints ;
                ?>
                <img src="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>"
                     class="img-fluid"
                     alt="<?php echo esc_attr($altclints); ?>"
                     title="<?php echo esc_attr($titleclints); ?>" />
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>

<?php }
wp_reset_postdata(); ?>
<!-- End Clints -->










<?php get_footer(); ?>
