<?php

/**/

class navwalker extends Walker_Nav_Menu {

    /**
     * Starts the list before the elements are added.
     */

    function start_lvl(&$output, $depth = 0, $args = array())
    {
        $output .= '<ul class="sub-list list-unstyled depth-'. $depth .'">' . "\n";
    }


    /**
     * Ends the list of after the elements are added.
     */
    function end_lvl(&$output, $depth = 0, $args = array())
    {
        $output .= "</ul>" . "\n";

    }

    /**
     * Start the element output.
     */
    function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
    {
        global $wp_query;

        $class_names = $value = '';
        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $classes[] = 'menu-item-' . $item->ID;
        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
        if ( in_array( 'current-menu-item', $classes ) )
            $class_names .= ' active';


        if ( 0 == $depth && !in_array('menu-item-has-children', $item->classes) ) {
            $output .= sprintf( "\n<li  class=\"link $class_names\"><a class='' href='%s'%s>%s</a>\n",
                $item->url,
                ( $item->object_id === get_the_ID() ) ? ' class="active"' : '',
                $item->title
            );
        }
        if (  $depth === 0 && in_array('menu-item-has-children', $item->classes) ) {
            $output .= sprintf( "\n<li  class=\"link  $class_names\"><a class='has_sub_menu ' href='%s'%s>%s</a><i class=\"fas fa-angle-down\"></i>\n",
                $item->url,
                ( $item->object_id === get_the_ID() ) ? ' class="active"' : '',
                $item->title
            );
        }
        if (  $depth > 0 && in_array('menu-item-has-children', $item->classes) ) {
            $output .= sprintf( "\n<li  class=\"link  $class_names\"><a class='has_sub_menu' href='%s'%s>%s</a><i class=\"fas fa-angle-down\"></i>\n",
                $item->url,
                ( $item->object_id === get_the_ID() ) ? ' class="active"' : '',
                $item->title
            );
        }
        elseif ( 1 <= $depth) {



            $output .= sprintf( "\n<li  class=\"link $class_names\"><a class='' href='%s'%s>%s</a>\n",
                $item->url,
                ( $item->object_id === get_the_ID() ) ? ' class="active"' : '',
                $item->title
            );
        }
    }

    function end_el(&$output, $item, $depth = 0, $args = array())
    {
        if ( 0 == $depth ) {
            $output .= "</li>";
        }
        elseif ( 1 <= $depth ) {
            $output .= '</li>';
        }
    }
}