<?php
get_header();

// جلب التيرم الحالي (الأب)
$main_term = get_queried_object();
$taxonomy_name = $main_term->taxonomy;

// دالة مساعدة لطباعة هيدر القسم (الصورة + العنوان الصغير + الوصف)
function render_term_vessel_header($term, $taxonomy) {
    $term_id_acf = $taxonomy . '_' . $term->term_id;
    $small_title = get_field('the_font_text_category', $term_id_acf);
    $image = get_field('image_category-veels', $term_id_acf);
    $desc = term_description($term->term_id, $taxonomy);

    $html = '<div class="term-section-header mb-4">';
    
    // 1. العنوان الصغير
    if (!empty($small_title)) {
        $html .= '<div id="term-header">' . esc_html($small_title) . '</div>';
    }
    
    // 2. الصورة
    if (!empty($image)) {
        $img_url   = $image['url'];
        $img_title = !empty($image['title']) ? $image['title'] : $term->name;
        $img_alt   = !empty($image['alt']) ? $image['alt'] : $img_title;
        $html .= '<div class="term-img-vessel mb-3">
                    <img src="' . esc_url($img_url) . '" alt="' . esc_attr($img_alt) . '" title="' . esc_attr($img_title) . '" class="img-fluid" />
                  </div>';
    }
    
    // 3. الوصف
    if (!empty($desc)) {
        $html .= '<div class="termvels-description">' . $desc . '</div>';
    }
    
    $html .= '</div>';
    return $html;
}
?>
<div class="mainsingle">
    <div class="container  ">
        <div id="vessels-full-archive">
    
            <?php 
            // --- 1. عرض القسم الأب (الحالي) ---
            echo render_term_vessel_header($main_term, $taxonomy_name); 
    
            $parent_query = new WP_Query( array(
                'post_type'      => 'vessels',
                'posts_per_page' => -1, // عرض الكل أو 12 حسب رغبتك
                'tax_query'      => array(
                    array(
                        'taxonomy'         => $taxonomy_name,
                        'field'            => 'term_id',
                        'terms'            => $main_term->term_id,
                        'include_children' => false, // بوستات الأب فقط
                    ),
                ),
            ) );
    
            if ( $parent_query->have_posts() ) : ?>
                <h4 class="titelcats"><?php echo esc_html( $main_term->name ); ?></h4>
                <div class="row mb-5">
                    <?php $servdelay = .2; while ( $parent_query->have_posts() ) : $parent_query->the_post(); ?>
                        <div class="col-md-3 mb-4">
                            <div class="projectitm-inside wow fadeInUp" data-wow-delay="<?php echo $servdelay; ?>s">
                                <?php
                                $thumb_id = get_post_thumbnail_id();
                                $alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true) ?: get_the_title();
                                ?>
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>" class="img-fluid" alt="<?php echo esc_attr($alt); ?>" title="<?php the_title_attribute(); ?>" />
                                    <h5><?php the_title(); ?></h5>
                                </a>
                            </div>
                        </div>
                    <?php $servdelay += .2; endwhile; ?>
                </div>
                <?php wp_reset_postdata(); ?>
            <?php endif; ?>
    
    
            <?php 
            // --- 2. عرض الأبناء (كل إبن بالهيدر بتاعه وعناصره) ---
            $children = get_terms( array(
                'taxonomy'   => $taxonomy_name,
                'parent'     => $main_term->term_id,
                'hide_empty' => true,
            ) );
    
            if ( !empty($children) ) :
                foreach ( $children as $child ) :
                    
                    // طباعة هيدر الإبن (صورة + عنوان صغير + وصف)
                    echo render_term_vessel_header($child, $taxonomy_name);
    
                    $child_query = new WP_Query( array(
                        'post_type' => 'vessels',
                        'posts_per_page' => -1,
                        'tax_query' => array(
                            array(
                                'taxonomy' => $taxonomy_name,
                                'field'    => 'term_id',
                                'terms'    => $child->term_id,
                            ),
                        ),
                    ) );
    
                    if ( $child_query->have_posts() ) : ?>
                        <h5 class="mb-3 mt-4">
                            <a href="<?php echo get_term_link($child); ?>" class="titchild wow fadeInUp">
                                <?php echo esc_html( $child->name ); ?>
                            </a>
                        </h5>
                        <div class="row mb-5">
                            <?php $servdelay = .2; while ( $child_query->have_posts() ) : $child_query->the_post(); ?>
                                <div class="col-md-3 mb-4">
                                    <div class="projectitm-inside wow fadeInUp" data-wow-delay="<?php echo $servdelay; ?>s">
                                        <a href="<?php the_permalink(); ?>">
                                            <img src="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>" class="img-fluid" alt="<?php the_title_attribute(); ?>" />
                                            <h5><?php the_title(); ?></h5>
                                        </a>
                                    </div>
                                </div>
                            <?php $servdelay += .2; endwhile; ?>
                        </div>
                        <?php wp_reset_postdata(); ?>
                    <?php endif;
                endforeach;
            endif; ?>
    
            <?php if ( !$parent_query->have_posts() && empty($children) ) : ?>
                <div class="text-center py-5">
                    <h3 class="text-muted"><?php _e("لا توجد عناصر حاليا"); ?></h3>
                </div>
            <?php endif; ?>
    
        </div>
    </div>
</div>
<?php get_footer(); ?>
