<?php get_header(); ?>

<section class="mainsingle">
    <div class="container">
        <?php if (have_posts()) { ?>
            <section class="exhibitionsec">

                    <div class="header-btn justify-content-center">
                        <ul class="nav nav-tabs " id="myTab" role="tablist">
                            <li class="nav-item wow fadeInUp" role="presentation" data-wow-delay= '.2s' >
                                <button class="nav-link active" id="video-tab" data-toggle="tab" data-target="#vids" type="button" role="tab" aria-controls="vids" aria-selected="false">
                                    <?php _e("<!--:en--> Videos <!--:--><!--:ar-->الفيديوهات  <!--:-->"); ?>
                                </button>
                            </li>

                            <li class="nav-item wow fadeInUp" role="presentation" data-wow-delay= '.3s'>
                                <button class="nav-link " id="image-tab" data-toggle="tab" data-target="#imgs" type="button" role="tab" aria-controls="imgs" aria-selected="true">
                                    <?php _e("<!--:en--> Pictures <!--:--><!--:ar-->الصور <!--:-->"); ?>
                                </button>
                            </li>

                        </ul>
                    </div>
                    <div class="tab-content" id="myTabContent">

                        <!-- ================== محتوى تاب الفيديوهات ================== -->
                        <div class="tab-pane fade show active" id="vids" role="tabpanel" aria-labelledby="video-tab">
                            <div class="gallery-container"> <!-- حاوية لتنظيم العناصر -->
                                <?php
                                // نسخة جديدة من الحلقة لجلب الفيديوهات فقط
                                $videos_loop = new WP_Query($loop->query_vars);
                                while (have_posts()) : the_post();
                                    // تحقق إذا كان المنشور يحتوي على فيديو
                                    if (get_field('check_videadded')) {
                                        $video_url = get_field('videocheckedyes');
                                        $thumbnail_url = get_the_post_thumbnail_url(null, 'full');
                                        $thumbnailexhi_id = get_post_thumbnail_id();
                                        $titleexhi = get_the_title($thumbnailexhi_id);
                                        $altexhi = get_post_meta($thumbnailexhi_id, '_wp_attachment_image_alt', true) ?: $titleexhi;
                                        ?>
                                        <div class="gallery-item">
                                            <img src="<?php echo esc_url($thumbnail_url); ?>" class="img-fluid" alt="<?php echo esc_attr($altexhi); ?>" title="<?php echo esc_attr($titleexhi); ?>" />
                                            <a href="<?php echo esc_url($video_url); ?>" data-fancybox="videos-gallery">
                                                <i class="fa-solid fa-play"></i> <!-- أيقونة تشغيل للفيديو -->
                                            </a>
                                        </div>
                                        <?php
                                    } // نهاية التحقق من الفيديو
                                endwhile;
                                wp_reset_postdata(); // إعادة تعيين بيانات المنشور
                                ?>

                            </div>
                            <div class="col-12 d-flex justify-content-center">
                                <?php
                                wp_paginate()
                                ?>
                            </div>
                        </div>

                        <!-- ================== محتوى تاب الصور ================== -->
                        <div class="tab-pane fade" id="imgs" role="tabpanel" aria-labelledby="image-tab">
                            <div class="gallery-container"> <!-- حاوية لتنظيم العناصر -->
                                <?php
                                // نسخة جديدة من الحلقة لجلب الصور فقط
                                $images_loop = new WP_Query($loop->query_vars);
                                while (have_posts()) : the_post();
                                    // تحقق إذا كان المنشور لا يحتوي على فيديو (أي أنه صورة)
                                    if (!get_field('check_videadded')) {
                                        $image_url = get_the_post_thumbnail_url(null, 'full');
                                        $thumbnailexhi_id = get_post_thumbnail_id();
                                        $titleexhi = get_the_title($thumbnailexhi_id);
                                        $altexhi = get_post_meta($thumbnailexhi_id, '_wp_attachment_image_alt', true) ?: $titleexhi;
                                        ?>
                                        <div class="gallery-item">
                                            <img src="<?php echo esc_url($image_url); ?>" class="img-fluid" alt="<?php echo esc_attr($altexhi); ?>" title="<?php echo esc_attr($titleexhi); ?>" />
                                            <a href="<?php echo esc_url($image_url); ?>" data-fancybox="images-gallery">
                                                <i class="fa-solid fa-circle-plus"></i>
                                            </a>
                                        </div>
                                        <?php
                                    } // نهاية التحقق من الصورة
                                endwhile;
                                wp_reset_postdata(); // إعادة تعيين بيانات المنشور
                                ?>

                            </div>
                            <div class="col-12 d-flex justify-content-center">
                                <?php
                                wp_paginate()
                                ?>
                            </div>
                        </div>

                    </div>


            </section>
        <?php } else { ?>
            <h3>
                <?php  _e("<!--:en--> No Items Found <!--:--><!--:ar--> لا توجد عناصر حاليا  <!--:-->"); ?>
            </h3>
        <?php } ?>
    </div>
</section>





<?php get_footer(); ?>
