<?php

/* Add Post Types */

include "functions/post-type.php";

require_once 'navwalker.php';
//***********************************************************************//
//***********************************************************************//

/* Add Theme Head */

function head_meta()
{
    ?>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="<?php bloginfo('description'); ?>"/>
    <link rel="profile" href="http://gmpg.org/xfn/11"/>
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>"/>
    <link rel="shortcut icon"
          href="<?php   the_field('icon', 'option'); ?>"
          type="image/x-icon"/>

    <?php
}

add_action('wp_head', 'head_meta');

//***********************************************************************//
//***********************************************************************//

/*Setup Theme*/

function a7md_setup()
{
    add_theme_support('automatic-feed-links');
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
}

add_action('after_setup_theme', 'a7md_setup');

//***********************************************************************//
//***********************************************************************//

/*Define Constants*/

define('theme_name', 'a7md');
define('THEME_ROOT', esc_url(get_template_directory_uri()));
define('THEME_IMAGES_DIR', THEME_ROOT . '/assets/img/');

//***********************************************************************//
//***********************************************************************//

/*Add Css & JavaScript Files */

function include_css_js_files ()
{
    //css_files

    wp_enqueue_style('boot_css', THEME_ROOT   . '/assets/css/bootstrap.min.css');
    wp_enqueue_style('fontawesome_css', THEME_ROOT   . '/assets/css/font-awesome-5all.css');
    wp_enqueue_style('FancyBox_css', THEME_ROOT   . '/assets/css/jquery.fancybox.css');
    wp_enqueue_style('carousel_css', THEME_ROOT   . '/assets/css/owl.carousel.min.css');
    wp_enqueue_style('animation_css', THEME_ROOT   . '/assets/css/animate.min.css');
    wp_enqueue_style('select2_css','https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css');
    wp_enqueue_style('sleck_css','https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css');
    wp_enqueue_style('sleckthumb_css','https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css');
    wp_enqueue_style('main_css', THEME_ROOT   . '/assets/css/main.css');

    //js_files

    wp_enqueue_script('html5shiv', "https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js");
    wp_script_add_data('html5shiv','conditional','lt IE 9');
    wp_enqueue_script('respond', 'https://oss.maxcdn.com/respond/1.4.2/respond.min.js');
    wp_script_add_data('respond','conditional','lt IE 9');
    wp_enqueue_script('jquery',THEME_ROOT   . '/assets/js/jquery-3.2.1.min.js',array(), null, true);
    wp_enqueue_script('bootstrap_js',THEME_ROOT   . '/assets/js/bootstrap.min.js',array(), null, true);
    wp_enqueue_script('FancyBox_js',THEME_ROOT   . '/assets/js/jquery.fancybox.js',array(), null, true);
    wp_enqueue_script('carousel_js', THEME_ROOT  . '/assets/js/owl.carousel.min.js',array(), null, true);
    wp_enqueue_script('sleck_js', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js');
    wp_enqueue_script('animation_js', THEME_ROOT   . '/assets/js/wow.min.js',array(), null, true);
    wp_enqueue_script('fontawseme_js', THEME_ROOT   . '/assets/js/all.js',array(), null, true);
    wp_enqueue_script('flatpickr_js', 'https://cdn.jsdelivr.net/npm/flatpickr',array(), null, true);
    wp_enqueue_script('main_js', THEME_ROOT   . '/assets/js/main.js',array(), null, true);
}

add_action('wp_enqueue_scripts','include_css_js_files');
//***********************************************************************//
add_theme_support('automatic-feed-links');
add_theme_support('title-tag');
add_theme_support('post-thumbnails');
//***********************************************************************//
/*register menus*/
//***********************************************************************//
register_nav_menus(array(
    'primary'  => __('Primary Menu', 'a7md'),
    'footer'  => __('footer Menu', 'a7md'),
));
//***********************************************************************//
/*option page*/
//***********************************************************************//
if (function_exists('acf_add_options_page')) {

    acf_add_options_page(array(
        'page_title' => __('إعدادت القالب', 'a7md'),
        'menu_title' => __('إعدادت القالب', 'a7md'),
        'menu_slug' => 'theme-settings',
        'capability' => 'edit_posts',
        'parent_slug' => '',
        'position' => false,
        'icon_url' => false,
    ));

    acf_add_options_sub_page(array(
        'page_title' => __('معلومات التواصل', 'a7md'),
        'menu_title' => __('معلومات التواصل', 'a7md'),
        'menu_slug' => 'main-setting',
        'capability' => 'edit_posts',
        'parent_slug' => 'theme-settings',
        'position' => false,
        'icon_url' => false
    ));

    acf_add_options_sub_page(array(
        'page_title' => __('أقسام الصفحة الرئسية', 'a7md'),
        'menu_title' => __('أقسام الصفحة الرئسية', 'a7md'),
        'menu_slug' => 'home-section',
        'capability' => 'edit_posts',
        'parent_slug' => 'theme-settings',
        'position' => false,
        'icon_url' => false
    ));

}

//***********************************************************************//
/*Hide the ACF menu*/
//***********************************************************************//
add_action('admin_menu', 'remove_acf_menu', 999);
function remove_acf_menu()
{
     remove_menu_page('edit.php?post_type=acf-field-group');
}
//***********************************************************************//
//***********************************************************************//




/* remove sub menu */

function my_remove_menu_elements()
{
    remove_submenu_page('themes.php', 'theme-editor.php');
    remove_submenu_page('themes.php', 'themes.php');
}

  add_action('admin_menu', 'my_remove_menu_elements', 102);
 
//***********************************************************************//
//***********************************************************************//

/*display favicon in admin dashboard*/

if (class_exists('acf')) {
    function add_favicon()
    {
        $favicon = get_field('icon', 'option');
        echo '<link rel="shortcut icon" href="' . $favicon . '" />';
    }

    add_action('admin_head', 'add_favicon');
}

//***********************************************************************//
//***********************************************************************//

/*change admin panel theme style*/
//*change admin panel theme style*/

function adminStyle()
{
    ?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Changa:wght@500&display=swap');
        img{
            max-width: 100%;
        }
        body,h1,h2,h3,h4,h5,h6 {
            font-family: 'Changa', sans-serif !important;
        }
        body::-webkit-scrollbar-track { ;
            background: #fff;
        }
        #wpadminbar .quicklinks #wp-admin-bar-woocommerce-site-visibility-badge a.ab-item{
            background-color: #888;
        }
        body::-webkit-scrollbar-thumb {
            background-color: #888;
            border-radius: 50px; }
        body::-webkit-scrollbar {
            width: .7em; }
        .wp-core-ui .button-primary,#wpadminbar,#adminmenu, #adminmenuback, #adminmenuwrap,#adminmenu .wp-has-current-submenu .wp-submenu, #adminmenu .wp-has-current-submenu.opensub .wp-submenu, #adminmenu .wp-submenu, #adminmenu a.wp-has-current-submenu:focus+.wp-submenu, .folded #adminmenu .wp-has-current-submenu .wp-submenu {
            background: #012a44 ;
        }
        #adminmenu li.current a.menu-top, #adminmenu li.wp-has-current-submenu .wp-submenu .wp-submenu-head, #adminmenu li.wp-has-current-submenu a.wp-has-current-submenu, .folded #adminmenu li.current.menu-top, #adminmenu a:hover, #adminmenu li.menu-top:hover, #adminmenu li.opensub>a.menu-top, #adminmenu li>a.menu-top:focus,#adminmenu .awaiting-mod, #adminmenu .update-plugins, #wpadminbar .menupop .ab-sub-wrapper, #wpadminbar .shortlink-input{
            background: #888 !important;
        }
        #adminmenu .wp-submenu .wp-submenu-head, #adminmenu .wp-has-current-submenu .wp-submenu a, #adminmenu .wp-has-current-submenu.opensub .wp-submenu a, #adminmenu .wp-submenu a, #adminmenu a.wp-has-current-submenu:focus+.wp-submenu a, .folded #adminmenu .wp-has-current-submenu .wp-submenu a{
            color: #e6e7e6 !important;
        }
        body {
            background: #ffffff !important;
        }
        #wpadminbar #wp-admin-bar-language > div.ab-item, #wpadminbar #wp-admin-bar-language ul li{
            background-color: transparent;
        }
        #adminmenu .awaiting-mod, #adminmenu .update-plugins,#wpadminbar .menupop .ab-sub-wrapper, #wpadminbar .shortlink-input{
            background: #243935;
        }
        #adminmenu li.current a.menu-top, #adminmenu li.wp-has-current-submenu .wp-submenu .wp-submenu-head, #adminmenu li.wp-has-current-submenu a.wp-has-current-submenu, .folded #adminmenu li.current.menu-top, #adminmenu a:hover, #adminmenu li.menu-top:hover, #adminmenu li.opensub>a.menu-top, #adminmenu li>a.menu-top:focus{
            background-color: #888;
        }
        #adminmenu div.wp-menu-image:before,#adminmenu a,.wp-core-ui .button-primary.focus, .wp-core-ui .button-primary.hover, .wp-core-ui .button-primary:focus, .wp-core-ui .button-primary:hover,.wp-core-ui .button-primary,#collapse-button,#adminmenu .wp-has-current-submenu .wp-submenu .wp-submenu-head, #adminmenu .wp-menu-arrow, #adminmenu .wp-menu-arrow div, #adminmenu li.current a.menu-top, #adminmenu li.wp-has-current-submenu a.wp-has-current-submenu, .folded #adminmenu li.current.menu-top, .folded #adminmenu li.wp-has-current-submenu,#wpadminbar .ab-empty-item, #wpadminbar a.ab-item, #wpadminbar>#wp-toolbar span.ab-label, #wpadminbar>#wp-toolbar span.noticon,#wpadminbar #adminbarsearch:before, #wpadminbar .ab-icon:before, #wpadminbar .ab-item:before{
            color: #fff !important;
        }
        #adminmenu .opensub .wp-submenu li.current a, #adminmenu .wp-submenu li.current, #adminmenu .wp-submenu li.current a, #adminmenu .wp-submenu li.current a:focus, #adminmenu .wp-submenu li.current a:hover, #adminmenu a.wp-has-current-submenu:focus+.wp-submenu li.current a{
            color: #fff !important;
        }
    </style>
    <?php
}

add_action('admin_notices', 'adminStyle');
//***********************************************************************//
//***********************************************************************//

/*custom login*/

function customLogin()
{
    ?>
    <style>
        body {
            /*background-color: transparent !important;*/
        }

        .login #backtoblog a,
        .login #nav a {
            /*color: #fff !important;*/
        }

        #login h1 a,
        .login h1 a {
            background-image: none;
        }

        #login h1,
        .login h1 {
            background-image: url(<?php the_field('logo', 'option'); ?>);
            background-position: center top;
            background-repeat: no-repeat;
            background-size: contain;
        }
    </style>
    <?php
}

add_action('login_enqueue_scripts', 'customLogin');

//***********************************************************************//
//***********************************************************************//

/*Contact form 7 remove span*/

add_filter('wpcf7_form_elements', function ($content) {
    $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);
    $content = str_replace('<br />', '', $content);
    return $content;
});

//***********************************************************************//
//***********************************************************************//

/* the numbers of litter to show */

//function get_excerpt($count)
//{
//    global $post;
//
//    $permalink = get_permalink($post->ID);
//
//    $excerpt = get_the_content();
//
//    $excerpt = strip_tags($excerpt);
//
//    $excerpt = substr($excerpt, 0, $count);
//
//    $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
//
//    $excerpt = $excerpt;
//
//    return $excerpt;
//}

function get_excerpt($count) {
    global $post;
    $text = get_the_content();
    if ( '' != $text ) {
        $text = strip_shortcodes( $text );
        $text = apply_filters('the_content', $text);
        $text = str_replace(']]>', ']]>', $text);
        $excerpt_length = $count; // 20 words
        $excerpt_more = apply_filters('excerpt_more', ' ' . '...');
        $text = wp_trim_words( $text, $excerpt_length, $excerpt_more );
    }
    return apply_filters('the_excerpt', $text);
}


//***********************************************************************//
//***********************************************************************//



/************************************************************************/
/* language switcher */
/************************************************************************/

/*
 * get lang
 */

function get_lang()
{
    global $q_config;
    return $q_config['language'];
}

/*
 * switch language .
 */

function the_switch_language($ar, $en)
{

    if (get_lang() == 'ar') {

        echo $ar;

    } elseif (get_lang() == 'en') {

        echo $en;

    }
}

function get_switch_language($ar, $en)
{
    if (get_lang() == 'ar') {

        return $ar;

    } elseif (get_lang() == 'en') {

        return $en;
    }
}
///* ar date */
//
//$months = array("Jan" => "يناير", "Feb" => "فبراير", "Mar" => "مارس", "Apr" => "أبريل", "May" => "مايو", "Jun" => "يونيو", "Jul" => "يوليو", "Aug" => "أغسطس", "Sep" => "سبتمبر", "Oct" => "أكتوبر", "Nov" => "نوفمبر", "Dec" => "ديسمبر");
//$your_date = date('y-m-d'); // The Current Date
//$en_month = date("M", strtotime($your_date));
//foreach ($months as $en => $ar) {
//    if ($en == $en_month) {
//        $ar_month = $ar;
//    }
//}
//
//$find = array("Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri");
//$replace = array("السبت", "الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة");
//$ar_day_format = date('D'); // The Current Day
//$ar_day = str_replace($find, $replace, $ar_day_format);
//
//header('Content-Type: text/html; charset=utf-8');
//$standard = array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
//$eastern_arabic_symbols = array("٠", "١", "٢", "٣", "٤", "٥", "٦", "٧", "٨", "٩");
//$current_date = $ar_day . ' ' . date('d') . ' / ' . $ar_month . ' / ' . date('Y');
//$arabic_date = str_replace($standard, $eastern_arabic_symbols, $current_date);
//
///* ar date */
//


function dynamic_field_values ( $tag, $unused ) {

    if ( $tag['name'] != 'dropdown-menu' )
        return $tag;

    $args = array (
        'numberposts'   => -1,
        'post_type'     => 'agency',
        'orderby'       => 'title',
        'order'         => 'ASC',
    );

    $custom_posts = get_posts($args);

    if ( ! $custom_posts )
        return $tag;

    foreach ( $custom_posts as $custom_post ) {

        $tag['raw_values'][] = $custom_post->post_title;
        $tag['values'][] = $custom_post->ID;
        $tag['labels'][] = $custom_post->post_title;

    }

    return $tag;

}

add_filter( 'wpcf7_form_tag', 'dynamic_field_values', 10, 2);


add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );
  
function custom_override_checkout_fields( $fields ) {
     
 
    $fields['billing']['billing_address_2']['label'] = 'الجنسية';


 
 
 

        
    return $fields;
}




// start session
add_action('init','cf7_start_session',1);
function cf7_start_session(){
    if(!session_id()) session_start();
}

// AJAX endpoint لإخراج صورة الكابتشا
add_action('wp_ajax_nopriv_cf7_captcha_img','cf7_captcha_img');
add_action('wp_ajax_cf7_captcha_img','cf7_captcha_img');

function cf7_captcha_img(){
    if(!function_exists('imagecreatetruecolor')) wp_die('GD not available');

    $width = 140; $height = 40;
    $im = imagecreatetruecolor($width,$height);

    // خلفية
    $bg = imagecolorallocate($im, 255,255,255);
    imagefilledrectangle($im,0,0,$width,$height,$bg);

    // خطوط تشويش
    for($i=0;$i<30;$i++){
        $c = imagecolorallocate($im, mt_rand(150,220), mt_rand(150,220), mt_rand(150,220));
        imageline($im, mt_rand(0,$width), mt_rand(0,$height), mt_rand(0,$width), mt_rand(0,$height), $c);
    }

    // نص عشوائي
    $chars = 'ABCDEFGHJKLMNPRSTUVWXYZ23456789';
    $len = 5; $text = '';
    for($i=0;$i<$len;$i++) $text .= $chars[mt_rand(0,strlen($chars)-1)];
    $_SESSION['cf7_captcha'] = $text;

    // كتابة الحروف (لو عندك فونت TTF استخدم imagettftext للنتيجة الأجمل)
    $font = get_stylesheet_directory() . '/fonts/arial.ttf'; // ضع فونت داخل مجلد القالب fonts/ أو عدّل المسار
    if(file_exists($font)){
        for($i=0;$i<$len;$i++){
            $size = 18;
            $angle = mt_rand(-25,25);
            $x = 10 + $i * 24 + mt_rand(-2,2);
            $y = mt_rand(25,32);
            $col = imagecolorallocate($im, mt_rand(0,120), mt_rand(0,120), mt_rand(0,120));
            imagettftext($im, $size, $angle, $x, $y, $col, $font, $text[$i]);
        }
    } else {
        // fallback بسيط
        $col = imagecolorallocate($im,0,0,0);
        imagestring($im, 5, 10, 10, $text, $col);
    }

    header('Content-Type: image/png');
    imagepng($im);
    imagedestroy($im);
    exit;
}

// إضافة تاج مخصص لـ Contact Form 7: [cf7captcha mycaptcha]
add_action('wpcf7_init','cf7_add_form_tag');
function cf7_add_form_tag(){
    wpcf7_add_form_tag('cf7captcha','cf7_captcha_form_tag', array('name-attr'=>true));
}

function cf7_captcha_form_tag($tag){
    $name = $tag->name ? $tag->name : 'cf7_captcha';
    $img_src = admin_url('admin-ajax.php?action=cf7_captcha_img&rand=' . mt_rand());
    $html = '<div class="cf7-captcha-wrap">';
    $html .= '<a href="#" class="cf7-captcha-refresh" onclick="var img=this.parentNode.querySelector(\'.cf7-captcha-img\'); img.src=\''.esc_js(admin_url('admin-ajax.php?action=cf7_captcha_img')).'&rand=\'+Math.random(); return false;">↻</a>';

    $html .= '<img class="cf7-captcha-img" src="'.esc_url($img_src).'" alt="captcha" onclick="this.src=\''.esc_js(admin_url('admin-ajax.php?action=cf7_captcha_img')).'&rand=\'+Math.random();" style="cursor:pointer;vertical-align:middle;" />';

    $html .= ' <input type="text" name="'.esc_attr($name).'" class="cf7-captcha-input wpcf7-form-control wpcf7-text wpcf7-validates-as-required" size="6" aria-required="true" required /> ';
    $html .= '</div>';
    return $html;
}

// التحقق من قيمة الكابتشا عند الإرسال
add_filter('wpcf7_validate_text','cf7_captcha_validation',20,2);
add_filter('wpcf7_validate_text*','cf7_captcha_validation',20,2);

function cf7_captcha_validation($result, $tag){
    $name = $tag->name;
    if(!$name) return $result;

    // عدل اسم الحقل لو استخدمت اسم مختلف
    if($name === 'mycaptcha' || strpos($name,'captcha') !== false || $name === 'cf7_captcha'){
        $value = isset($_POST[$name]) ? trim($_POST[$name]) : '';
        if( empty($_SESSION['cf7_captcha']) || strcasecmp($_SESSION['cf7_captcha'], $value) !== 0 ){
            $result->invalidate($tag, "رمز التحقق غير صحيح. حاول مرة أخرى.");
        }
    }
    return $result;
}

// بعد الإرسال الناجح نمسح القيمة من الجلسة
add_action('wpcf7_mail_sent','cf7_clear_captcha');
function cf7_clear_captcha($contact_form){
    if(isset($_SESSION['cf7_captcha'])) unset($_SESSION['cf7_captcha']);
}




// يطبع شوية جافاسكربت في الهيدر في صفحة الأدمين لتعريف acf.escHtml لو مش موجودة
add_action('admin_head', 'acf_compat_eschtml_shim', 1);
function acf_compat_eschtml_shim() {
    ?>
    <script type="text/javascript">
        (function($){
            if (typeof window.acf === 'undefined') window.acf = {};
            if (typeof acf.escHtml !== 'function') {
                acf.escHtml = function(html) {
                    // منقي بسيط لاستبدال & < > ... باستخدام jQuery (حماية من XSS)
                    return $('<div/>').text(html).html();
                };
            }
        })(jQuery);
    </script>
    <?php
}

add_action('admin_footer', 'acf_fix_icon_select2_display', 99);
function acf_fix_icon_select2_display() {
    ?>
    <script>
        (function($){
            $(document).ready(function(){

                // نبحث عن كل select اللي واحدة على الأقل من option بتحتوي "<i"
                $('select').each(function(){
                    var $s = $(this);
                    var hasIcon = false;
                    $s.find('option').each(function(){
                        if ( $(this).text().indexOf('<i') !== -1 ) hasIcon = true;
                    });
                    if (!hasIcon) return; // نكمل للـ next

                    // 1) نحول النص (اللي غالبًا محرف/مُهَرب) إلى HTML فعلي داخل كل option
                    $s.find('option').each(function(){
                        var $opt = $(this);
                        var txt = $opt.text();

                        // decode HTML entities (لو محوّل) ثم set كـ HTML داخل option
                        var decoded = $('<textarea/>').html(txt).text();
                        $opt.html(decoded);
                    });

                    // 2) نعيد تهيئة select2 ونسمح بعرض HTML (templates)
                    try {
                        if ($s.data('select2')) $s.select2('destroy');
                    } catch(e){}

                    $s.select2({
                        width: '100%',
                        dropdownAutoWidth: true,
                        escapeMarkup: function(m){ return m; }, // منع الهروب من الـ HTML
                        templateResult: function(data) {
                            // data.element is the original <option> element
                            if (!data.id) return data.text;
                            if (data.element) {
                                return $('<span/>').html( $(data.element).html() );
                            }
                            return data.text;
                        },
                        templateSelection: function(data) {
                            if (!data.id) return data.text;
                            if (data.element) {
                                return $('<span/>').html( $(data.element).html() );
                            }
                            return data.text;
                        }
                    });

                }); // each select

                // إذا عندك ACF dynamic fields (repeater/clone) لازم تعيد التطبيق بعد الإضافة
                $(document).on('acf/append', function(e, $el){
                    $el.find('select').trigger('change.select2'); // اندفاعة بسيطة لإعادة التهيئة لو لزم
                });

            });
        })(jQuery);
    </script>
    <?php
}

add_action('acf/input/admin_enqueue_scripts', function() {
    wp_add_inline_script(
        'acf-input',
        'if(typeof acf !== "undefined" && typeof acf.escHtml === "undefined"){ acf.escHtml = function(s){ return s; }; }'
    );
});


add_action('admin_head', function () {
    global $post;

    if (!$post) return;

    if (get_page_template_slug($post->ID) === 'page-who.php') {
        ?>
        <style>
            #postdivrich,
            #postimagediv {
                display: none !important;
            }
        </style>
        <?php
    }
});



// AJAX لتحميل القسم كامل (Header + Content)
function load_vessels_by_term_ajax() {
    // التحقق من nonce
    if ( ! isset($_POST['nonce']) || ! wp_verify_nonce( $_POST['nonce'], 'vessels_ajax_nonce' ) ) {
        wp_send_json_error( 'Security check failed' );
    }

    $term_id = intval( $_POST['term_id'] );
    if ( ! $term_id ) {
        wp_send_json_error( 'Invalid term ID' );
    }
    
    $taxonomy_name = 'vesselss_taxonomy';
    
    // جلب بيانات التيرم
    $term = get_term( $term_id, $taxonomy_name );
    if ( is_wp_error($term) || ! $term ) {
        wp_send_json_error( 'Term not found' );
    }
    
    // حقول ACF
    $term_id_for_acf = $taxonomy_name . '_' . $term->term_id;
    $image = get_field('image_category-veels', $term_id_for_acf);
    $small_title = get_field('the_font_text_category', $term_id_for_acf);
    
    // تجهيز الصورة
    $image_url = !empty($image['url']) ? $image['url'] : '';
    $image_title = !empty($image['title']) ? $image['title'] : $term->name;
    $image_alt = !empty($image['alt']) ? $image['alt'] : $image_title;
    
    // Header HTML
    $header_html = '';
    if ( !empty($small_title) ) {
        $header_html .= '<div>' . esc_html( $small_title ) . '</div>';
    }
    
    if ( !empty($image_url) ) {
        $header_html .= '<div>
            <img src="' . esc_url($image_url) . '" 
                 alt="' . esc_attr($image_alt) . '" 
                 title="' . esc_attr($image_title) . '" 
                 class="img-fluid  "   />
        </div>';
    }
    
    $term_desc = term_description( $term->term_id, $taxonomy_name );
    if ( !empty( $term_desc ) ) {
        $header_html .= '<div class="termvels-description">' . $term_desc . '</div>';
    }
    
    // Content HTML (الأب + الأبناء)
    $content_html = '';
    
    // 1. بوستات الأب
    $parent_query = new WP_Query( array(
        'post_type'      => 'vessels',
        'posts_per_page' => 12,
        'paged'          => 1,
        'tax_query'      => array(
            array(
                'taxonomy' => $taxonomy_name,
                'field'    => 'term_id',
                'terms'    => $term->term_id,
            ),
        ),
    ) );
    
    if ( $parent_query->have_posts() ) {
        $content_html .= '<h4 class="titelcats">' . esc_html( $term->name ) . '</h4>';
        $content_html .= '<div class="row mb-5">';
        $servdelay = .2;
        while ( $parent_query->have_posts() ) : $parent_query->the_post();
            $thumbnailproj_id = get_post_thumbnail_id();
            $titleproj = get_the_title($thumbnailproj_id);
            $altproj = get_post_meta($thumbnailproj_id, '_wp_attachment_image_alt', true) ?: $titleproj;
            $content_html .= '
            <div class="col-md-3 mb-4">
                <div class="projectitm-inside wow fadeInUp" data-wow-delay="' . $servdelay . 's">
                    <a href="' . esc_url(get_permalink()) . '">
                        <img src="' . esc_url(get_the_post_thumbnail_url(null, 'full')) . '" 
                             class="img-fluid"
                             alt="' . esc_attr($altproj) . '" 
                             title="' . esc_attr($titleproj) . '" />
                        <h5>' . esc_html(get_the_title()) . '</h5>
                    </a>
                </div>
            </div>';
            $servdelay += .2;
        endwhile;
        $content_html .= '</div>';
        wp_reset_postdata();
    }
    
    // 2. الأبناء
    $children_terms = get_terms( array(
        'taxonomy'   => $taxonomy_name,
        'parent'     => $term->term_id,
        'hide_empty' => true,
    ) );
    
    if ( !empty($children_terms) && !is_wp_error($children_terms) ) {
        foreach ( $children_terms as $child ) {
            $child_query = new WP_Query( array(
                'post_type'      => 'vessels',
                'posts_per_page' => 12,
                'tax_query'      => array(
                    array(
                        'taxonomy' => $taxonomy_name,
                        'field'    => 'term_id',
                        'terms'    => $child->term_id,
                    ),
                ),
            ) );
            
            if ( $child_query->have_posts() ) {
                $content_html .= '<h5 class="mb-3 mt-5">
                    <a href="' . esc_url(get_term_link($child)) . '" class="titchild wow fadeInUp">
                        ' . esc_html($child->name) . '
                    </a>
                </h5>';
                $content_html .= '<div class="row mb-4">';
                $servdelay = .2;
                while ( $child_query->have_posts() ) : $child_query->the_post();
                    $thumbnailproj_id = get_post_thumbnail_id();
                    $titleproj = get_the_title($thumbnailproj_id);
                    $altproj = get_post_meta($thumbnailproj_id, '_wp_attachment_image_alt', true) ?: $titleproj;
                    $content_html .= '
                    <div class="col-md-3 mb-4">
                        <div class="projectitm-inside wow fadeInUp" data-wow-delay="' . $servdelay . 's">
                            <a href="' . esc_url(get_permalink()) . '">
                                <img src="' . esc_url(get_the_post_thumbnail_url(null, 'full')) . '" 
                                     class="img-fluid"
                                     alt="' . esc_attr($altproj) . '" 
                                     title="' . esc_attr($titleproj) . '" />
                                <h5>' . esc_html(get_the_title()) . '</h5>
                            </a>
                        </div>
                    </div>';
                    $servdelay += .2;
                endwhile;
                $content_html .= '</div>';
                wp_reset_postdata();
            }
        }
    }
    
    // لو مفيش بوستات خالص
    if ( empty($parent_query->posts) && ( empty($children_terms) || ! $children_terms ) ) {
        $content_html .= '<div class="row">
            <div class="col-12 text-center py-5">
                <h3 class="text-muted">' . __("<!--:en--> No Items Found <!--:--><!--:ar--> لا توجد عناصر حاليا  <!--:-->") . '</h3>
            </div>
        </div>';
    }
    
    // إرجاع JSON صحيح
    wp_send_json_success( array(
        'header'  => $header_html,
        'content' => $content_html
    ) );
}
add_action('wp_ajax_load_vessels_by_term', 'load_vessels_by_term_ajax');
add_action('wp_ajax_nopriv_load_vessels_by_term', 'load_vessels_by_term_ajax');
