<?php

/* vessels Post Type */

function create_post_types_vessels() {
    register_post_type( 'vessels', array(
            'labels'              => array(
                'name'               => __( 'السفن', 'a7md' ),
                'singular_name'      => __( 'السفن', 'a7md' ),
                'add_new'            => __( 'إضافة سفينة', 'a7md' ),
                'add_new_item'       => __( 'سفينة جديد', 'a7md' ),
                'all_items'          => __( 'السفن', 'a7md' ),
                'edit_item'          => __( 'تحرير سفينة', 'a7md' ),
                'new_item'           => __( 'سفينة جديد', 'a7md' ),
                'view_item'          => __( 'معاينة سفينة', 'a7md' ),
                'search_items'       => __( 'البحث عن سفينة', 'a7md' ),
                'not_found'          => __( 'لا توجد سفينة', 'a7md' ),
                'not_found_in_trash' => __( 'لا توجد سفينة', 'a7md' ),
                'parent_item_colon'  => ''
            ),
            'menu_icon'           => 'dashicons-admin-generic',
            'hierarchical'        => true,
            'public'              => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'menu_position'       => 6,
            'supports'            => array(
                'thumbnail',
                'title',
                'excerpt',
                'editor',
                // 'tags'
            ),
            'query_var'           => true,
            'rewrite'             => array( 'slug' => 'vessels' ),
        )
    );
}

add_action( 'init', 'create_post_types_vessels' );

// hook into the init action and call create_vessels_taxonomies when it fires
add_action( 'init', 'create_vesselss_taxonomies', 0 );
// create two taxonomies, genres and writers for the post type "prints"
function create_vesselss_taxonomies() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => __( 'أقسام السفن', 'a7md' ),
        'all_items'         => __( 'كافة الأقسام', 'a7md' ),
    );

    $args = array(
        'hierarchical'        => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'vessels-category' ),
    );

    register_taxonomy( 'vesselss_taxonomy', array( 'vessels' ), $args );
}