<?php get_header(); ?>

    <section class="content sec-padding team-page">
        <div class="container">
            <h1 class="sec-tit text-center">
                <?php post_type_archive_title(); ?>
            </h1>
            <?php if (have_posts()) : ?>
                <div class="row">
                    <?php while (have_posts()) : the_post(); ?>
                        <div class="col-md-4 mb-4">
                            <div class="team-member">
                                <a class="team-member-url d-block"
                                   href="<?php the_permalink(); ?>"
                                   title="<?php the_title(); ?>">
                                    <div class="team-member-avatar">
                                        <?php the_post_thumbnail('large', ['class' => 'img-fluid']); ?>
                                    </div>
                                    <div class="team-member-info">
                                        <h6 class="team-member-name"><?php the_title(); ?></h6>
                                        <div class="team-member-extra-data">
                                            <?php if (get_field('position')): ?>
                                                <h6 class="team-member-position">
                                                    <?php the_field('position'); ?>
                                                </h6>
                                            <?php endif; ?>
                                            <div class="team-member-exp">
                                                <?php echo(has_excerpt() ? get_the_excerpt() : get_excerpt('10')) ?>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
                <?php wp_pagenavi(); ?>

            <?php else : ?>
                <p>
                    <?php _e('معذرة , لا يوجد محتوى مضاف حاليا', 'm7md') ?>
                </p>
            <?php endif; ?>
        </div>
    </section>

<?php get_footer(); ?>