<?php get_header(); ?>

<section class="content sec-padding">
    <div class="container">
        <h1 class="sec-tit text-center">
            <?php the_archive_title(); ?>
        </h1>
        <?php if (have_posts()) : ?>
            <div class="row">
                <?php while (have_posts()) : the_post(); ?>
                    <div class="col-md-4">
                        <div class="news-item">
                            <div class="news-item-thumb">
                                <?php the_post_thumbnail('full', ['class' => 'img-fluid']); ?>
                            </div>
                            <div class="news-item-body">
                                <h5 class="news-item-tit">
                                    <a href="<?php the_permalink(); ?>"
                                       title="<?php the_title(); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </h5>
                                <div class="news-item-des">
                                    <?php echo(has_excerpt() ? get_the_excerpt() : get_excerpt('10')) ?>
                                </div>
                                <div class="news-item-url">
                                    <a class="main-btn"
                                       href="<?php the_permalink(); ?>"
                                       title="<?php the_title(); ?>">
                                        <span><?php _e('اقرأ المزيد', 'm7md') ?></span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
            <?php wp_pagenavi(); ?>

        <?php else : ?>
            <p>
                <?php _e('معذرة , لا يوجد محتوى مضاف حاليا', 'm7md') ?>
            </p>
        <?php endif; ?>

    </div>
</section>

<?php get_footer(); ?>
