jQuery(function () {
    'use strict';

    // Mobile Menu
    jQuery('.mobile-nav-list .sub-menu').slideUp();
    jQuery('.mobile-nav-list .menu-item > i').on('click', function () {
        if (jQuery(this).hasClass('open')) {
            jQuery(this).siblings('.sub-menu').slideUp();
            jQuery(this).removeClass('open');
        } else {
            jQuery(this).parent().siblings(".menu-item").find(".sub-menu").slideUp();
            jQuery(this).parent().siblings(".menu-item").find("i").removeClass("open");
            jQuery(this).siblings('.sub-menu').slideDown();
            jQuery(this).addClass('open')
        }
    });
    jQuery('.nav-btn').on('click', function () {
        jQuery('.mobile-nav-list, .nav-overlay').addClass('trans-none');
        return false;
    });
    jQuery('.nav-overlay, .close-bar').on('click', function () {
        jQuery('.mobile-nav-list, .nav-overlay').removeClass('trans-none')
    });

    // Check if Rtl
    var rtlVal = false;
    jQuery('html').attr("dir") == "ltr" ? rtlVal = false : rtlVal = true;
    //
    jQuery('.main-slider').owlCarousel({
        rtl: rtlVal,
        margin: 0,
        smartSpeed: 1500,
        nav: true,
        navText: ['<i class="fas fa-long-arrow-alt-left"></i>', '<i class="fas fa-long-arrow-alt-right"></i>'],
        dots: true,
        loop: true,
        autoplay: true,
        mouseDrag: true,
        touchDrag: true,
        rewind: true,
        responsive: {
            0: {
                items: 1
            },
            768: {
                items: 1
            },
            992: {
                items: 1
            }
        }
    });
    //
    jQuery('.clients-carousel').owlCarousel({
        rtl: rtlVal,
        margin: 30,
        smartSpeed: 1500,
        nav: true,
        navText: ['<i class="fas fa-long-arrow-alt-left"></i>', '<i class="fas fa-long-arrow-alt-right"></i>'],
        dots: false,
        loop: true,
        autoplay: true,
        mouseDrag: true,
        touchDrag: true,
        rewind: true,
        responsive: {
            0: {
                items: 1
            },
            768: {
                items: 3
            },
            992: {
                items: 6
            }
        }
    });


    //
    jQuery('.fancybox').fancybox();



    //ScrollReveal
    window.sr = ScrollReveal({
        reset: true,
        duration: 500,
        useDelay: "always",
        mobile: false,
        //delay: 200,
        afterReveal: function (el) {
            jQuery(el).attr("style", "");
        }
    });
    // sr.reveal(".about-des,.division-item,.pro-item,.news-item", {origin: "top"});
    //  sr.reveal(".about-content ul li,.about-url", {origin: "bottom"});
    // sr.reveal(".about-img", {origin: "right"});
    // sr.reveal(".tab-about", {origin: "left"});

});
;