<?php
include "functions/navwalker.php";
include "functions/excerpt.php";
include "functions/post-type.php";
include "functions/comment-function.php";
//include "functions/views-num.php";
/************************************************************************/
/* Theme Head */
/************************************************************************/
add_action('wp_head', 'head_meta');
function head_meta(){ ?>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="<?php bloginfo('description'); ?>"/>
    <link rel="profile" href="http://gmpg.org/xfn/11"/>
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>"/>
    <link rel="shortcut icon"
          href="<?php echo get_field('favicon', 'option')['url']; ?>"
          type="image/x-icon"/>
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <?php
    global $post;
    $post = get_post();
    $og_title = get_the_title() . ' - ' . get_bloginfo('name');
    $og_description = $post->post_content;
    $og_description = strip_tags(strip_shortcodes($og_description));
    $post_thumb = get_the_post_thumbnail_url($post->ID);
    $og_url = get_permalink();
    $og_type = 'article';

    if (is_home() || is_front_page()) :
        $og_title = get_bloginfo('name');
        $og_url = get_bloginfo('url');
        $og_description = get_bloginfo('description');
        $og_type = 'website';
    endif
    ?>

    <meta property="og:title" content="<?php echo $og_title ?>"/>
    <meta property="og:type" content="<?php echo $og_type ?>"/>
    <meta property="og:description" content="<?php echo wp_html_excerpt($og_description, 100) ?>"/>
    <meta property="og:url" content="<?php echo $og_url ?>"/>
    <meta property="og:site_name" content="<?php echo get_bloginfo('name') ?>"/>
    <?php if (empty($post_thumb) || is_home() || is_front_page() || is_category() || is_post_type_archive() || is_archive() || is_tag() || is_search()) : ?>
    <meta property="og:image" content="<?php the_field('logo', 'option') ?>"/>
<?php else : ?>
    <meta property="og:image" content="<?php echo $post_thumb ?>"/>
<?php endif; ?>
    <?php
}

/************************************************************************/
/* Setup Theme */
/************************************************************************/
add_action('after_setup_theme', 'm7md_setup');
function m7md_setup(){
    add_theme_support('automatic-feed-links');
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
}
/************************************************************************/
/*  Define Constants */
/************************************************************************/
define('theme_name', 'm7md');
define('THEME_ROOT', esc_url(get_template_directory_uri()));
define('THEME_VERSION', esc_url(get_template_directory_uri()));
define('THEME_IMAGES_DIR', THEME_ROOT . '/assets/images/');
/************************************************************************/
/*  Enqueue scripts and styles */
/************************************************************************/
add_action('wp_enqueue_scripts', 'm7md_scripts');
function m7md_scripts(){
    wp_enqueue_style('bootstrap', THEME_ROOT . '/assets/css/bootstrap.min.css');
    wp_enqueue_style('fontawesome', THEME_ROOT . '/assets/fonts/fontawesome/css/all.min.css');
    wp_enqueue_style('slick', THEME_ROOT . '/assets/css/owl.carousel.min.css');
    wp_enqueue_style('fancybox', THEME_ROOT . '/assets/css/jquery.fancybox.css');
    wp_enqueue_style('style', THEME_ROOT . '/assets/css/style.css');

    wp_enqueue_script('jq-lib', THEME_ROOT . '/assets/js/jquery-3.5.1.min.js', array('jquery'), '1', true);
    wp_enqueue_script('popper', THEME_ROOT . '/assets/js/popper.min.js', array('jquery'), '1', true);
    wp_enqueue_script('bootstrap', THEME_ROOT . '/assets/js/bootstrap.min.js', array('jquery'), '1', true);
    wp_enqueue_script('slick', THEME_ROOT . '/assets/js/owl.carousel.min.js', array('jquery'), '1', true);
    wp_enqueue_script('fancybox', THEME_ROOT . '/assets/js/jquery.fancybox.js', array('jquery'), '1', true);
    wp_enqueue_script('scrollreveal', THEME_ROOT . '/assets/js/scrollreveal.min.js', array('jquery'), '1', true);
    wp_enqueue_script('plugin', THEME_ROOT . '/assets/js/plugin.js', array('jquery'), '1', true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
/************************************************************************/
/* register menus */
/************************************************************************/
register_nav_menus(array(
    'primary'    => __('القائمة الرئسية', 'm7md'),
    'footer'    => __('القائمة الفوتر', 'm7md'),
));
/************************************************************************/
/* option page */
/************************************************************************/
if (function_exists('acf_add_options_page')) :
    acf_add_options_page(array(
        'page_title' => __('إعدادت القالب', 'm7md'),
        'menu_title' => __('إعدادت القالب', 'm7md'),
        'menu_slug' => 'theme-settings',
        'capability' => 'edit_posts',
        'parent_slug' => '',
        'position' => false,
        'icon_url' => false,
    ));
    acf_add_options_sub_page(array(
        'page_title' => __('الإعدادت العامة', 'm7md'),
        'menu_title' => __('الإعدادت العامة', 'm7md'),
        'menu_slug' => 'main-setting',
        'capability' => 'edit_posts',
        'parent_slug' => 'theme-settings',
        'position' => false,
        'icon_url' => false
    ));
    acf_add_options_sub_page(array(
        'page_title' => __('الصفحة الرئسية', 'm7md'),
        'menu_title' => __('الصفحة الرئسية', 'm7md'),
        'menu_slug' => 'home-section',
        'capability' => 'edit_posts',
        'parent_slug' => 'theme-settings',
        'position' => false,
        'icon_url' => false
    ));
endif;
/************************************************************************/
/* Hide the ACF menu*/
/************************************************************************/
add_filter('acf/settings/show_admin', '__return_false');
add_action('admin_menu', 'remove_acf_menu', 999);
function remove_acf_menu(){
    remove_menu_page('edit.php?post_type=acf-field-group');
}
/************************************************************************/
/* remove sub menu */
/************************************************************************/
add_action('admin_menu', 'my_remove_menu_elements', 102);
function my_remove_menu_elements(){
    remove_submenu_page('themes.php', 'theme-editor.php');
    remove_submenu_page('themes.php', 'themes.php');
}
/************************************************************************/
/* display favicon in admin dashboard */
/************************************************************************/
if (class_exists('acf')) :
    add_action('admin_head', 'add_favicon');
    function add_favicon(){
        echo '<link rel="shortcut icon" href="' . get_field('favicon', 'option')['url'] . '" />';
    }
endif;
/************************************************************************/
/* change admin panel theme style*/
/************************************************************************/
add_action('admin_notices', 'adminStyle');
function adminStyle(){ ?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Reem+Kufi&display=swap');

        body {
            font-family: 'Reem Kufi', sans-serif !important;
        }
    </style>
    <?php
}
/************************************************************************/
/* custom login */
/************************************************************************/
add_action('login_enqueue_scripts', 'customLogin');
function customLogin(){
    if (class_exists('acf')) :
        echo '<link rel="shortcut icon" href="' . get_field('favicon', 'option')['url'] . '" />';
    endif;
    ?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Reem+Kufi&display=swap');
        body {
            font-family: 'Reem Kufi', sans-serif !important;
            background-color: #14366d !important;
        }

        .login #backtoblog a,
        .login #nav a {
            color: #fff !important;
        }

        #login h1 a,
        .login h1 a {
            background-image: none;
        }

        #login h1,
        .login h1 {
            background-image: url(<?php echo get_field('logo', 'option')['url'] ; ?>);
            background-position: center top;
            background-repeat: no-repeat;
            background-size: contain;
        }
    </style>
    <?php
}
/**/
add_filter('login_headerurl', 'my_login_logo_url');
function my_login_logo_url(){
    return home_url();
}
/**/
add_filter('login_headertitle', 'my_login_logo_url_title');
function my_login_logo_url_title(){
    return get_bloginfo('name');
}
/************************************************************************/
/* language switcher */
/************************************************************************/
/* Get Lang */
function get_lang(){
    global $q_config;
    return $q_config['language'];
}
/* Switch Language */
function the_switch_language($ar, $en){
    if (get_lang() == 'ar') {
        echo $ar;
    } elseif (get_lang() == 'en') {
        echo $en;
    }
}

function get_switch_language($ar, $en){
    if (get_lang() == 'ar') {
        return $ar;
    } elseif (get_lang() == 'en') {
        return $en;
    }
}
/************************************************************************/
/* move wpautop filter to AFTER shortcode is processed */
/************************************************************************/
add_filter('wpcf7_autop_or_not', 'wpcf7_autop_return_false');
function wpcf7_autop_return_false(){
    return false;
}
/************************************************************************/
/* Contact form 7 remove span */
/************************************************************************/
//add_filter('wpcf7_form_elements', function ($content) {
//    $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);
//    $content = str_replace('<br />', '', $content);
//    return $content;
//});
/************************************************************************/
/* Add Dir To HTML Tag */
/************************************************************************/
add_filter('language_attributes', 'custom_dir_attr');
function custom_dir_attr($lang){
    if (is_rtl()) {
        $dir_attr = 'dir="rtl"';
    } else {
        $dir_attr = 'dir="ltr"';
    }
    return $lang . " " . $dir_attr;
}
/************************************************************************/
/* display tax name as class for Projects Terms */
/************************************************************************/
function term_class_name($post){
    if (get_the_terms($post->ID, 'projects_cat')) {
        $terms = get_the_terms($post->ID, 'projects_cat'); ?>
        <?php foreach ($terms as $term) {
            $term_link = get_term_link($term);
            echo '<a href="' . esc_url($term_link) . '">' . $term->name . '</a> ';
        }
    }
}
/************************************************************************/
/* display tax id for Projects Terms */
/************************************************************************/
function term_class_id($post){
    if (get_the_terms($post->ID, 'projects_cat')) {
        $terms = get_the_terms($post->ID, 'projects_cat'); ?>
        <?php foreach ($terms as $term) {
            echo 'cat-' . $term->term_taxonomy_id, ' ';
        }
    }
}


/***/
add_action('admin_head', 'admin_head_script');
function admin_head_script()
{
    ?>

    <style>
        #profile-page .user-admin-color-wrap,
        #profile-page .show-admin-bar,
        #profile-page .user-language-wrap,
        #profile-page .application-passwords,
        #profile-page #qtranxs_user_config{
    display: none;
}

    </style>

    <?php
}

