<?php

/****************************************/
/*comments */
/****************************************/


// Comment Navigation
if (!function_exists('themeton_comment_nav')) :
    function themeton_comment_nav()
    {
        // Are there comments to navigate through?
        if (get_comment_pages_count() > 1 && get_option('page_comments')) :
            ?>
            <nav class="navigation comment-navigation" role="navigation">
                <h2 class="screen-reader-text"><?php _e('Comment navigation', 'nrgagency'); ?></h2>
                <div class="nav-links">
                    <?php
                    if ($prev_link = get_previous_comments_link(__('Older Comments', 'nrgagency'))) :
                        printf('<div class="nav-previous">%s</div>', $prev_link);
                    endif;

                    if ($next_link = get_next_comments_link(__('Newer Comments', 'nrgagency'))) :
                        printf('<div class="nav-next">%s</div>', $next_link);
                    endif;
                    ?>
                </div><!-- .nav-links -->
            </nav><!-- .comment-navigation -->
            <?php
        endif;
    }
endif;

function alter_comment_form_fields($fields)
{
    $commenter = wp_get_current_commenter();
    $req = get_option('require_name_email');
    $aria_req = ($req ? " aria-required='true'" : '');

    $fields['author'] = '<div class="input-group">
                            <span class="input-group-addon icon_profile"></span>
                            <input type="text" name="author" id="author" value="' . esc_attr($commenter['comment_author']) . '" tabindex="1" class="form-control" placeholder="Name *" ' . $aria_req . '/>
                        </div>';

    $fields['email'] = '<div class="input-group">
                            <span class="input-group-addon icon_mail_alt"></span>
                            <input type="text" name="email" id="email" value="' . esc_attr($commenter['comment_author_email']) . '" tabindex="2" class="form-control"  placeholder="Email *"/>
                        </div>';
    $fields['url'] = '<div class="input-group clearfix">
                            <span class="input-group-addon icon_globe-2"></span>
                            <input type="text" name="url" id="url" value="' . esc_attr($commenter['comment_author_url']) . '" tabindex="3" class="form-control"  placeholder="Website"/>
                        </div>';

    return $fields;
}

add_filter('comment_form_default_fields', 'alter_comment_form_fields');

function themeton_custom_comment($comment, $args, $depth)
{
    $GLOBALS['comment'] = $comment;

    if ('div' == $args['style']) {
        $tag = 'div';
        $add_below = ' comment';
    } else {
        $tag = 'li ';
        $add_below = 'div-comment';
    }

    switch ($comment->comment_type) :
        case 'pingback' :
        case 'trackback' :
            ?>
            <<?php echo esc_attr($tag); ?> class="post pingback">
            <p><?php _e('Pingback:', 'nrgagency'); ?><?php comment_author_link(); ?><?php edit_comment_link(__('Edit', 'nrgagency'), '<span class="edit-link">', '</span>'); ?></p>
            <?php
            break;
        default:
            ?>

            <<?php echo esc_attr($tag) ?><?php comment_class(empty($args['has_children']) ? '' : 'parent') ?> id="comment-<?php comment_ID() ?>">

            <div class="comment-box">
                <div class="row">
                    <div class="col-md-2">
                        <?php echo get_avatar($comment, 80); ?>
                    </div>
                    <div class="col-md-10">
                        <div class="vcard author post-author">
                            <h5 class="comment-user-name"><?php comment_author(); ?></h5>
                            <?php printf(__('%1$s at %2$s', 'nrgagency'), get_comment_date(), get_comment_time()); ?>
                        </div>
                        <div class="comments-desc">
                            <?php comment_text(); ?>
                            <?php edit_comment_link(__('Edit', 'nrgagency'), '  ', ''); ?>
                            <?php comment_reply_link(array_merge($args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            break;
    endswitch;
}