<?php
class navwalker extends Walker_Nav_Menu {

    /** Starts the list before the elements are added. **/
    function start_lvl(&$output, $depth = 0, $args = array()){
        $depth == 0 ? $output .= '<ul class="sub-menu depth-'. $depth .'">' . "\n" : $output .= '<ul class="sub-menu depth-'. $depth .'">' . "\n";
    }

    /** Ends the list of after the elements are added. **/
    function end_lvl(&$output, $depth = 0, $args = array()){
        $output .= "</ul>" . "\n";
    }

    /**Start the element output.**/
    function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
    {
        global $wp_query;
        $class_names = $value = '';
        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $classes[] = 'menu-item-' . $item->ID;
        $id    = apply_filters( 'nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args, $depth );
        $id ? ' id="' . esc_attr( $id ) . '"' : '';
        $atts                = array();
        $atts[ 'title' ]     = ! empty( $item->attr_title ) ? $item->attr_title : '';
        $atts[ 'target' ]    = ! empty( $item->target ) ? $item->target : '';
        $atts[ 'rel' ]       = ! empty( $item->xfn ) ? $item->xfn : '';
        $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );
        $attributes = '';
        foreach ( $atts as $attr => $value ) {
            if ( ! empty( $value ) ) {
                $value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }
        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
        if ( in_array( 'current-menu-item', $classes ) )
            $class_names .= ' active';
        if ( 0 == $depth && !in_array('menu-item-has-children', $item->classes) ) {
            $output .= sprintf( "\n<li  class=\"linkMenu menu-item $class_names\"><a $attributes class='' href='%s'%s>%s</a>\n",
                $item->url,
                ( $item->object_id === get_the_ID() ) ? ' class="active"' : '',
                $item->title
            );
        }
        if (  $depth === 0 && in_array('menu-item-has-children', $item->classes) ) {
            $output .= sprintf( "\n<li  class=\"linkMenu2 menu-item $class_names\"><a $attributes class='' href='%s'%s>%s</a><i class='dd-trigger fal fa-long-arrow-alt-down'></i>\n",
                $item->url,
                ( $item->object_id === get_the_ID() ) ? ' class="active"' : '',
                $item->title
            );
        }
        if (  $depth > 0 && in_array('menu-item-has-children', $item->classes) ) {
            $output .= sprintf( "\n<li class=\"linkMenu3 menu-item $class_names\"><a $attributes class='' href='%s'%s>%s</a><i class='dd-trigger fal fa-long-arrow-alt-down'></i>\n",
                $item->url,
                ( $item->object_id === get_the_ID() ) ? ' class="active"' : '',
                $item->title
            );
        }
        elseif ( 1 <= $depth) {
            $output .= sprintf( "\n<li  class=\"linkMenu4 menu-item $class_names\"><a $attributes class='' href='%s'%s>%s</a>\n",
                $item->url,
                ( $item->object_id === get_the_ID() ) ? ' class="active"' : '',
                $item->title
            );
        }
    }

    function end_el(&$output, $item, $depth = 0, $args = array())
    {
        if ( 0 == $depth ) {
            $output .= "</li>";
        }
        elseif ( 1 <= $depth ) {
            $output .= '</li>';
        }
    }
}