<?php
/*************************************************************************************/
/* registering products post type.* /
/**************************************************************************************/
add_action( 'init', 'create_post_types_products' );
function create_post_types_products() {
    register_post_type( 'products', array(
            'labels'              => array(
                'name'               => __( 'المنتجات', 'm7md' ),
                'singular_name'      => __( 'المنتجات', 'm7md' ),
                'add_new'            => __( 'إضافة منتج', 'm7md' ),
                'add_new_item'       => __( 'منتج جديدة', 'm7md' ),
                'all_items'          => __( 'المنتجات', 'm7md' ),
                'edit_item'          => __( 'تحرير منتج', 'm7md' ),
                'new_item'           => __( 'منتج جديدة', 'm7md' ),
                'view_item'          => __( 'معاينة منتج', 'm7md' ),
                'search_items'       => __( 'البحث عن منتج', 'm7md' ),
                'not_found'          => __( 'لا يوجد منتج', 'm7md' ),
                'not_found_in_trash' => __( 'لا يوجد منتج', 'm7md' ),
                'parent_item_colon'  => ''
            ),
            'menu_icon'           => 'dashicons-admin-generic',
            'hierarchical'        => false,
            'public'              => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'menu_position'       => 6,
            'supports'            => array(
                'thumbnail',
                'title',
                'editor',
                //'excerpt',
                //'tags',
            ),
            'query_var'           => true,
            'rewrite'             => array( 'slug' => 'products' ),
        )
    );
}



// hook into the init action and call create_products_taxonomies when it fires
//add_action( 'init', 'create_products_taxonomies', 0 );
// create two taxonomies, genres and writers for the post type "prints"
function create_products_taxonomies() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => __( 'أقسام المنتجات', 'm7md' ),
        'all_items'         => __( 'كافة الأقسام', 'm7md' ),
    );

    $args = array(
        'hierarchical'        => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'productsCat' ),
    );

    register_taxonomy( 'products_cat', array( 'products' ), $args );
}
