
<?php
global $user_ID, $user_identity;
$current_user = wp_get_current_user();
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <link rel="profile" href="http://gmpg.org/xfn/11"/>
    <?php wp_head(); ?>
</head>

<body <?php body_class(''); ?> >

<main class="wrap">

    <section class="nav-overlay"></section>

    <section class="mobile-nav-list">
        <a class="mobile-logo text-center"
           href="<?php echo home_url(); ?>"
           title="<?php echo get_field('logo', 'option')['title']; ?>">
            <img class="img-fluid"
                 src="<?php echo get_field('logo', 'option')['url']; ?>"
                 alt="<?php echo get_field('logo', 'option')['alt']; ?>">
        </a>
        <?php
        wp_nav_menu(array(
            'theme_location' => 'primary',
            'container' => '',
            'container_id' => '',
            'container_class' => '',
            'menu_id' => false,
            'menu_class' => 'mobile-list list-unstyled',
            'depth' => 4,
            'fallback_cb' => 'navwalker::fallback',
            'walker' => new navwalker()
        ));
        ?>
    </section>

    <header class="head-home">

        <div class="container-fluid">
            <div class="main-nav">
                <a class="menu-logo"
                   href="<?php echo home_url(); ?>"
                   title="<?php echo get_field('logo', 'option')['title']; ?>">
                    <img class="img-fluid"
                         src="<?php echo get_field('logo', 'option')['url']; ?>"
                         alt="<?php echo get_field('logo', 'option')['alt']; ?>">
                </a>
                <?php
                wp_nav_menu(array(
                    'theme_location' => 'primary',
                    'container' => '',
                    'container_id' => '',
                    'container_class' => '',
                    'menu_id' => false,
                    'menu_class' => 'nav-list',
                    'depth' => 4,
                    'fallback_cb' => 'navwalker::fallback',
                    'walker' => new navwalker()
                ));
                ?>

                <?php if (!is_user_logged_in()) : ?>
                    <ul class="user-list list-unstyled">
                        <li class="user-list-item">
                            <a href="javascript:void(0)">
                                <?php _e( 'دخول', 'm7md' ) ?>
                                <i class="fas fa-angle-down"></i>
                            </a>
                            <ul class="sub-user-list list-unstyled">
                                <li><a  href="<?php echo get_page_link(154); ?>"><?php _e( 'تسجيل دخول', 'm7md' ) ?></a></li>
                                <li><a href="<?php echo get_page_link(156); ?>"><?php _e( 'حساب جديد', 'm7md' ) ?></a></li>
                            </ul>
                        </li>
                    </ul>

                <?php else: ?>
                    <ul class="user-list list-unstyled">
                        <li class="user-list-item">
                            <a  href="javascript:void(0)">
                                <?php _e('مرحبا', 'm7md') ?>
                                <?php echo esc_html($current_user->nickname); ?> !
                                <i class="fas fa-angle-down"></i>
                            </a>
                            <ul class="sub-user-list list-unstyled">
                                <li><a href="<?php echo get_page_link(160) ?>"><?php _e( 'الملف الشخصى', 'm7md' ) ?></a></li>
                                <li><a href="<?php echo get_page_link(162); ?>"><?php _e( 'تعديل الملف الشخصى', 'm7md' ) ?></a></li>
                                <li><a href="<?php echo get_page_link(164); ?>"><?php _e( 'القضايا', 'm7md' ) ?></a></li>
                                <li><a href="<?php echo wp_logout_url(site_url()); ?>"><?php _e( 'تسجيل خروج', 'm7md' ) ?></a></li>
                            </ul>
                        </li>
                    </ul>
                <?php endif; ?>


                <div class="menu-icons d-flex align-items-center">
                    <?php the_switch_language('<a class="lang" href="?lang=en"> En </a>',
                        '<a class="lang" href="?lang=ar"> ع </a>') ?>
                    <a class="nav-btn"
                       href="javascript:void(0)">
                        <i class="fal fa-bars"></i>
                    </a>
                </div>
            </div>
        </div>
    </header>

<?php if (!is_home()) : get_template_part('template-parts/breadcrumb'); endif; ?>