<?php /*Template Name: blog */ ?>
<?php get_header(); ?>
    <section class="content sec-padding sec-bg">
        <div class="container">
            <h1 class="sec-tit text-center">
                <?php the_title(); ?>
            </h1>

            <?php if (!empty(get_the_content()) || (has_post_thumbnail())): ?>
                <div class="page-main mb-5">
                    <div class="container">
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="page-thumb text-center mb-2">
                                <?php the_post_thumbnail('full', ['class' => 'img-fluid mx-auto d-block']); ?>
                            </div>
                        <?php endif; ?>

                        <?php while (have_posts()) : the_post(); ?>
                            <div class="page-editor">
                                <?php the_content(); ?>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <?php
        global $wp_query;
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        query_posts('post_type=post&order=DESC' . '&paged=' . $paged);
        if (have_posts()) : ?>
            <div class="page-posts">
                <div class="container">
                    <div class="row">
                        <?php while (have_posts()) : the_post(); ?>
                            <div class="col-md-4">
                                <div class="news-item">
                                    <div class="news-item-thumb">
                                        <?php the_post_thumbnail('full', ['class' => 'img-fluid']); ?>
                                    </div>
                                    <div class="news-item-body">
                                        <h5 class="news-item-tit">
                                            <a href="<?php the_permalink(); ?>"
                                               title="<?php the_title(); ?>">
                                                <?php the_title(); ?>
                                            </a>
                                        </h5>
                                        <div class="news-item-des">
                                            <?php echo(has_excerpt() ? get_the_excerpt() : get_excerpt('10')) ?>
                                        </div>
                                        <div class="news-item-url">
                                            <a class="main-btn"
                                               href="<?php the_permalink(); ?>"
                                               title="<?php the_title(); ?>">
                                                <span><?php _e('اقرأ المزيد', 'm7md') ?></span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <?php wp_pagenavi(); ?>
                </div>
            </div>
        <?php endif;
        wp_reset_query(); ?>

    </section>
<?php get_footer(); ?>