<?php /*Template Name: form */ ?>
<?php get_header(); ?>

<section class="content sec-padding sec-bg">

    <div class="container">
        <h1 class="sec-tit text-center">
            <?php the_title(); ?>
        </h1>

        <?php if (!empty(get_the_content()) || (has_post_thumbnail())): ?>
            <div class="page-main mb-5">
                <div class="container">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="page-thumb text-center mb-2">
                            <?php the_post_thumbnail('full', ['class' => 'img-fluid mx-auto d-block']); ?>
                        </div>
                    <?php endif; ?>

                    <?php while (have_posts()) : the_post(); ?>
                        <div class="page-editor">
                            <?php the_content(); ?>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="page-form">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-10">
                    <div class="form">
                        <?php echo do_shortcode('[contact-form-7 id="' . get_field('forms') . '" ]'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>

<?php get_footer(); ?>
