<?php /*Template Name: cases */ ?>
<?php get_header(); ?>


<section class="content">

    <div class="page-main sec-padding sec-bg">
        <div class="container">
            <h1 class="sec-tit text-center">
                <?php the_title(); ?>
            </h1>


            <?php if (is_user_logged_in()) {
                $userId = get_current_user_id();
                ?>

                    <?php if (have_rows('cases', 'user_' . $userId)): ?>
                        <div class="cases-items">
                            <?php while (have_rows('cases', 'user_' . $userId)): the_row(); ?>
                                <div class="case-wrap">
                                    <h3 class="sec-tit text-center case-name"><?php the_sub_field('case_tit', 'user_' . $userId); ?></h3>
                                    <?php if (have_rows('case_item', 'user_' . $userId)): ?>
                                        <?php while (have_rows('case_item', 'user_' . $userId)): the_row(); ?>
                                            <div class="case-item">
                                                <h5 class="case-item-tit"><?php the_sub_field('case_item_name'); ?></h5>
                                                <p class="case-item-des"><?php the_sub_field('case_item_des'); ?></p>
                                                <div class="case-item-date"><?php the_sub_field('case_item_date'); ?></div>
                                            </div>
                                        <?php endwhile; ?>
                                    <?php endif; ?>
                                </div>
                            <?php endwhile;  ?>
                        </div>
                    <?php endif;  ?>

            <?php } else { ?>
                <p>
                    <?php _e('معذرة , لا يوجد محتوى مضاف حاليا', 'm7md') ?>
                </p>
            <?php }
            ?>


        </div>
    </div>

</section>


<?php get_footer(); ?>
