<?php /*Template Name: profile edit */ ?>
<?php get_header(); ?>
<?php

global $wpdb, $current_user, $wp_roles;
$userId = get_current_user_id();
if (!is_user_logged_in()) {
    $home = esc_url(home_url(''));
    header("Location: $home");
    exit;
}
?>

<section class="content">
    <div class="page-main sec-padding sec-bg">
        <div class="container">
            <h1 class="sec-tit text-center">
                <?php the_title(); ?>
            </h1>

            <form class="mb-3" action="" method="post">
                <div class="form-group">
                    <label for="nickname"> <?php _e('اسم المستخدم ', 'm7md') ?></label>
                    <input id="nickname"
                           class="form-control"
                           name="com_fullname"
                           type="text"
                           value="<?php echo get_the_author_meta('nickname', $userId); ?>"
                           disabled>
                </div>
                <div class="form-group">
                    <label for="firstname"><?php _e(' الاسم الاول ', 'm7md') ?></label>
                    <input id="firstname"
                           class="form-control"
                           name="com_firstname"
                           type="text"
                           value="<?php echo get_the_author_meta('first_name', $userId); ?>"
                           placeholder="<?php _e('برجاء ادخال الاسم الاول', 'm7md') ?>">
                </div>
                <div class="form-group">
                    <label for="lastname"> <?php _e('الاسم الاخير ', 'm7md') ?></label>
                    <input id="lastname"
                           class="form-control"
                           name="com_lastname"
                           type="text"
                           value="<?php echo get_the_author_meta('last_name', $userId); ?>"
                           placeholder="<?php _e('برجاء ادخال الاسم الاخير', 'm7md') ?>">
                </div>
                <div class="form-group">
                    <label for="email"> <?php _e('البريد الالكترونى ', 'm7md') ?></label>
                    <input id="email"
                           class="form-control"
                           name="com_email"
                           type="email"
                           value="<?php the_author_meta('user_email', $current_user->ID); ?>">
                </div>
                <div class="form-group">
                    <label for="phone"><?php _e(' رقم الجوال ', 'm7md') ?></label>
                    <input id="phone"
                           class="form-control"
                           name="com_mobile"
                           type="text"
                           value="<?php echo get_the_author_meta('user_mobile', $userId); ?>"
                           placeholder="<?php _e('برجاء ادخال رقم الجوال ', 'm7md') ?>">
                </div>


                <div class="d-flex align-items-center justify-content-between">
                    <button class="main-btn"
                            name="com_submit"
                            type="submit">
                        <span><?php _e('حفظ التعديلات ', 'm7md') ?></span>
                    </button>

                    <a class="main-btn"
                       href="<?php echo get_page_link(151) ?>">
                        <span><?php _e('تغيير كلمة المرور', 'm7md') ?></span>
                    </a>
                </div>
            </form>
        </div>

        <?php
        if (isset($_POST['com_submit'])) {

            if ($_POST['com_firstname']) {
                update_user_meta($userId, 'first_name', $_POST['com_firstname']);
            }
            if ($_POST['com_lastname']) {
                update_user_meta($userId, 'last_name', $_POST['com_lastname']);
            }
            if ($_POST['com_email']) {
                update_user_meta($userId, 'user_email', $_POST['com_email']);
            }
            if ($_POST['com_mobile']) {
                update_user_meta($userId, 'user_mobile', $_POST['com_mobile']);
            }

            if ($_POST['com_email']) {
                $args = array(
                    'ID' => $userId,
                    'user_email' => esc_attr($_POST['com_email'])
                );
                wp_update_user($args);
            }
            $url = get_page_link(160);
            wp_redirect($url);// redirect to home page
        }
        ?>


    </div>
</section>


<?php get_footer(); ?>
