<?php /*Template Name: profile */ ?>
<?php get_header(); ?>

<?php

global $wpdb, $current_user, $wp_roles;
$userId = get_current_user_id();
if (!is_user_logged_in()) {
    $home = esc_url(home_url(''));
    header("Location: $home");
    exit;
}
?>

    <section class="content">

        <div class="page-main sec-padding sec-bg">
            <div class="container">
                <h1 class="sec-tit text-center">
                    <?php the_title(); ?>
                    ( <?php echo $current_user->nickname; ?>)
                </h1>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <tbody>
                        <tr>
                            <td><?php _e('إسم المستخدم', 'm7md') ?></td>
                            <td><?php the_author_meta('nickname', $current_user->ID); ?></td>
                        </tr>
                        <tr>
                            <td>
                                <?php _e('الأسم الأول', 'm7md') ?>:
                            </td>
                            <td><?php the_author_meta('first_name', $current_user->ID); ?></td>
                        </tr>

                        <tr>
                            <td>
                                <?php _e('الأسم الأخير', 'm7md') ?>:
                            </td>
                            <td><?php the_author_meta('last_name', $current_user->ID); ?></td>
                        </tr>
                        <tr>
                            <td>
                                <?php _e('البريد الألكترونى', 'm7md') ?>:
                            </td>
                            <td><?php the_author_meta('user_email', $current_user->ID); ?></td>
                        </tr>
                        <tr>
                            <td>
                                <?php _e('الجوال', 'm7md') ?>:
                            </td>
                            <td><?php the_author_meta('user_mobile', $current_user->ID); ?></td>
                        </tr>

                        </tbody>
                    </table>
                </div>

                <div class="profile-edit-url">
                    <a class="main-btn" href="<?php echo get_page_link(162) ?>">
                        <span><?php _e('تعديل البيانات', 'm7md') ?></span>
                    </a>
                </div>

            </div>
    </section>

<?php get_footer(); ?>