<?php
$images = get_sub_field('gallery_content');
if ($images): ?>
    <div class="gallery sec-padding sec-bg">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <?php foreach ($images as $image): ?>
                    <div class="col-md-2 mb-3">
                        <div class="gallery-item-image text-center">
                            <a class="fancybox"
                               data-fancybox="images"
                               href="<?php echo esc_url($image['url']); ?>"
                               title="<?php echo esc_html($image['caption']); ?>">
                                <img class="img-fluid img-thumbnail"
                                     src="<?php echo esc_url($image['sizes']['medium']); ?>"
                                     alt="<?php echo esc_attr($image['alt']); ?>">
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>