<?php
$args = array(
    'post_type' => 'clients',
    'posts_per_page' => 15,
    'no_found_rows' => true,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) :
?>

    <section class="clients">
        <div class="container">
            <h3 class="sec-tit text-center">
                <?php _e('عملائنا', 'm7md') ?>
            </h3>
            <div class="clients-carousel owl-carousel">
                <?php while ($loop->have_posts()) : $loop->the_post(); ?>
                <div class="client-item">
                    <div class="client-logo">
                        <?php the_post_thumbnail('large', ['class' => 'img-fluid']); ?>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
            <div class="more-url text-center">
                <a class="main-btn"
                   href="<?php echo get_post_type_archive_link( 'clients' ); ?>">
                    <span><?php _e('اقرأ المزيد', 'm7md') ?></span>
                </a>
            </div>
        </div>
    </section>

<?php endif;
wp_reset_postdata(); ?>