<?php
$args = array(
    'post_type' => 'products',
    'posts_per_page' => 12,
    'no_found_rows' => true,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) :
    ?>

    <section class="services">
        <div class="container">
            <h3 class="sec-tit text-white text-center">
                <?php _e( 'المنتجات', 'm7md' ) ?>
            </h3>
            <div class="row">
                <?php while ($loop->have_posts()) : $loop->the_post(); ?>
                    <div class="col-md-4">
                        <div class="ser-item">
                            <a class="ser-item-url d-flex align-items-center"
                               href="<?php the_permalink(); ?>"
                               title="<?php the_title(); ?>">
                                <div class="ser-item-icon">
                                    <img class="img-fluid"
                                         src="<?php echo get_field('serv_icon')['url']; ?>"
                                         alt="<?php echo get_field('serv_icon')['alt']; ?>">
                                </div>
                                <h6 class="ser-item-tit">
                                    <?php the_title(); ?>
                                </h6>
                            </a>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
    </section>

<?php endif;
wp_reset_postdata(); ?>