<?php get_header(); ?>

    <section class="content">
        <h1 class="pagetit text-center">
            <?php post_type_archive_title(); ?>
        </h1>
        <?php
        $args = array(
            'post_type' => 'workfields',
            'posts_per_page' => 6,
            'no_found_rows' => true,
        );
        $loop = new WP_Query($args);
        if ($loop->have_posts()) : ?>
            <!--  section lessons  -->
            <section class="wordfildsce">

                <div class="container">
                    <?php
                    // جلب جميع الأقسام (Terms)
                    $terms = get_terms(array(
                        'taxonomy' => 'workfields_taxonomy',
                        'hide_empty' => false,
                        'orderby' => 'name',
                        'order' => 'ASC'
                    ));

                    if (!empty($terms) && !is_wp_error($terms)) :
                        ?>

                        <div class="workfileds-tabs-wrapper">
                            <!-- أزرار الأقسام (Tabs Buttons) -->
                            <div class="tabs-buttons">
                                <?php foreach ($terms as $index => $term) : ?>
                                    <button
                                            class="tab-btn <?php echo ($index === 0) ? 'active' : ''; ?> wow fadeInUp"
                                            data-tab="tab-<?php echo $term->term_id; ?>"
                                            data-term-id="<?php echo $term->term_id; ?>">

                                        <!-- اسم القسم -->
                                        <span class="tab-name"><?php echo esc_html($term->name); ?></span>

                                        <!-- عدد العناصر
                            <span class="tab-count"><?php echo $term->count; ?></span>-->
                                    </button>
                                <?php endforeach; ?>
                            </div>

                            <!-- محتوى الأقسام (Tabs Content) -->
                            <div class="tabs-content">
                                <?php foreach ($terms as $index => $term) :

                                    // جلب العناصر الخاصة بكل قسم
                                    $args = array(
                                        'post_type' => 'workfields',
                                        'posts_per_page' => 6,
                                        'tax_query' => array(
                                            array(
                                                'taxonomy' => 'workfields_taxonomy',
                                                'field' => 'term_id',
                                                'terms' => $term->term_id,
                                            ),
                                        ),
                                    );

                                    $query = new WP_Query($args);
                                    ?>

                                    <div
                                            class="tab-content <?php echo ($index === 0) ? 'active' : ''; ?>"
                                            id="tab-<?php echo $term->term_id; ?>"
                                            data-term-id="<?php echo $term->term_id; ?>">

                                        <?php if ($query->have_posts()) : ?>
                                            <div class="workfileds-grid row">

                                                <?php while ($query->have_posts()) : $query->the_post(); ?>

                                                    <div class="col-md-4 mb-5">
                                                        <article class="workfileds-item" data-course-id="<?php echo get_the_ID(); ?>">

                                                            <a href="<?php the_permalink(); ?>">
                                                                <div class="workfileds-icon">
                                                                    <img class="img-fluid" src="<?php the_field('iconfilds') ?>" />
                                                                </div>
                                                                <h4>
                                                                    <?php the_title() ?>

                                                                </h4>
                                                                <p><?php
                                                                    $short_desc = get_field('short_desc');
                                                                    if (strlen($short_desc) > 90) {
                                                                        echo mb_substr($short_desc, 0, 90) . '...';
                                                                    } else {
                                                                        echo $short_desc;
                                                                    }
                                                                    ?></p>

                                                            </a>

                                                        </article>
                                                    </div>

                                                <?php endwhile; ?>
                                            </div>
                                        <?php else : ?>
                                            <p class="no-courses"> <?php _e('لا توجد مجالات', 'm7md') ?></p>
                                        <?php endif; ?>

                                        <?php wp_reset_postdata(); ?>
                                    </div>

                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </section>
            <!--  //section lessons  -->

        <?php endif;
        wp_reset_postdata(); ?>

    </section>

<?php get_footer(); ?>