<?php get_header(); ?>

    <section class="content">

        <div class="container">
            <h1 class="sec-tit text-center">
                <?php get_the_archive_title(); ?>
            </h1>

            <?php if (have_posts()) : ?>
                <div class="row">
                    <?php while (have_posts()) : the_post(); ?>
                        <div class="col-md-4">
                            <div class="news-item">
                                <div class="news-item-img">
                                    <?php the_post_thumbnail('full', ['class' => 'img-fluid']); ?>
                                </div>
                                <div class="news-item-body">
                                    <div class="news-item-date">
                                        <div class="text wow fadeInRight"
                                             data-wow-delay=".2">
                                            <i class="fa-solid fa-calendar-days"></i>
                                            <?php echo date('d-m-Y'); ?>
                                        </div>
                                    </div>
                                    <div class="news-item-tit">
                                        <?php the_title(); ?>
                                    </div>
                                    <div class="news-item-desc">
                                        <?php echo(has_excerpt() ? get_the_excerpt() : get_excerpt('50')) ?>
                                    </div>
                                    <div class="news-item-url">
                                        <a class='main-button'
                                           href="<?php the_permalink(); ?>"
                                           title="<?php the_title(); ?>">
                                            <span><?php _e('أقرأ المزيد', 'm7md') ?></span>

                                            <?php the_switch_language('<i class="fa-solid fa-arrow-left-long"></i>',
                                                '<i class="fa-solid fa-arrow-right-long"></i>') ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
                <?php wp_pagenavi(); ?>
            <?php else : ?>
                <p>
                    <?php _e('عذرا ، يتم حاليا إضافة المحتوى', 'm7md') ?>
                </p>
            <?php endif; ?>

        </div>
    </section>

<?php get_footer(); ?>