jQuery(function () {
    'use strict';

    // Viewing the uploaded file in a file input
    jQuery(document).on("change", ".uploadFile", function () {
        let input    = jQuery(this),
            fileName = jQuery(".uploadFileLabel");
        if (input.val() === "") {
            fileName.empty();
        } else {
            input.closest(".uploadBox").find(fileName).text(input.val().replace("C:\\fakepath\\", ""));
        }
    });


    // Upload Avatar
    function uploadAvatar(input, place) {
        if (input.files && input.files[0]) {
            let reader = new FileReader();
            reader.onload = function (e) {
                let preview = place;
                let newSrc = e.target.result;
                jQuery(preview).find('img').attr('src', newSrc);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    jQuery('.avatarUploadBtn input').change(function () {
        uploadAvatar(this, jQuery(this).parent().closest('.avatarUpload'));
    });
    
});
