<?php
if (post_password_required()) {
    return;
}
?>

<div id="comments" class="comment-area">

    <?php if (have_comments()) : ?>
        <h2 class="comment-title">
            <?php
            if (is_rtl()) {
                printf(_n(' تعليق واحد على  &ldquo;%2$s&rdquo;', '%1$s تعليقات على  &ldquo;%2$s&rdquo;', get_comments_number(), 'm7md'),
                    number_format_i18n(get_comments_number()), get_the_title());
            } else {
                printf(_n(' One thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', get_comments_number(), 'm7md'),
                    number_format_i18n(get_comments_number()), get_the_title());
            }
            ?>
        </h2>

        <?php themeton_comment_nav(); ?>

        <ol class="comment-list list-unstyled">
            <?php
            wp_list_comments(array(
                'style' => 'ol',
                'short_ping' => true,
                'avatar_size' => 56,
                'callback' => 'themeton_custom_comment'
            ));
            ?>
        </ol><!-- .comment-list -->

        <?php themeton_comment_nav(); ?>

    <?php endif; // have_comments() ?>

    <?php
    // If comments are closed and there are comments, let's leave a little note, shall we?
    if (!comments_open() && get_comments_number() && post_type_supports(get_post_type(), 'comments')) :
        ?>
        <p class="no-comments"><?php esc_attr_e('Comments are closed.', 'm7md'); ?></p>
    <?php endif; ?>

    <?php
    if (is_user_logged_in()):
        comment_form(
            array(
                'comment_field' => '<label class="sr-only" for="comment">' . esc_attr__('التعليق', 'm7md') . '</label>
                                        <textarea id="comment" name="comment" cols="50" rows="6" tabindex="4" class="tx-style" aria-required="true" placeholder="' . esc_attr__('التعليق', 'm7md') . '"></textarea>',
                'class_submit' => 'send',
                'comment_notes_after' => ''
            )
        );
    else:
        $req = get_option('require_name_email');
        $aria_req = ($req ? " aria-required='true'" : '');
        comment_form(
            array(
                'fields' => array(
                    'author' => '<div class="row"><div class="col-md-6">
                                        <label for="author" class="sr-only">' . esc_attr__('الأسم', 'm7md') . '</label>
                                        <input id="author" name="author" type="text" value="' . esc_attr($commenter['comment_author']) .
                        '" size="30"' . $aria_req . ' class="input-style" placeholder="' . esc_attr__('الأسم', 'm7md') . '" />
                                   </div>',

                    'email' => '<div class="col-md-6">
                                    <label for="email" class="sr-only">' . esc_attr__('البريد الإلكترونى', 'm7md') . '</label> 
                                    <input id="email" name="email" type="text" value="' . esc_attr($commenter['comment_author_email']) .
                        '" size="30"' . $aria_req . ' class="input-style" placeholder="' . esc_attr__('البريد الإلكترونى', 'm7md') . '" />
                                  </div></div>',

                    'url' => '<div class="row"><div class="col-md-12">
                                    <label for="url" class="sr-only">' . esc_attr__('الموقع', 'm7md') . '</label>
                                    <input id="url" name="url" type="text" value="' . esc_attr($commenter['comment_author_url']) .
                        '" size="30" class="input-style" placeholder="' . esc_attr__('الموقع', 'm7md') . '" />
                                  </div></div>',
                ),
                'comment_field' => '<div class="row"><div class="col-md-12 col-sm-12">
                                            <label class="sr-only" for="comment">' . esc_attr__('التعليق', 'm7md') . '</label>
                                            <textarea id="comment" name="comment" cols="50" rows="6" tabindex="4" class="tx-style" aria-required="true" placeholder="' . esc_attr__('التعليق', 'm7md') . '"></textarea>
                                        </div></div>',
                'class_submit' => 'send',
                'comment_notes_before' => '<p class="comment-notes">' .
                    esc_attr__('لن يتم نشر عنوان بريدك الإلكتروني.', 'm7md') .
                    '</p>',
                'comment_notes_after' => ''
            )
        );
    endif;
    ?>

</div><!-- .comments-area -->