<?php
/*************************************************************************************/
/* registering partners post type.* /
/**************************************************************************************/
add_action( 'init', 'create_post_types_partners' );
function create_post_types_partners() {
    register_post_type( 'partners', array(
            'labels'              => array(
                'name'               => __( 'شركاؤنا', 'm7md' ),
                'singular_name'      => __( 'شركاؤنا', 'm7md' ),
                'add_new'            => __( 'إضافه شريك', 'm7md' ),
                'add_new_item'       => __( 'شريك جديد', 'm7md' ),
                'all_items'          => __( 'شركاؤنا', 'm7md' ),
                'edit_item'          => __( 'تحرير شريك', 'm7md' ),
                'new_item'           => __( 'شريك جديد', 'm7md' ),
                'view_item'          => __( 'معاينة شريك', 'm7md' ),
                'search_items'       => __( 'البحث عن شريك', 'm7md' ),
                'not_found'          => __( 'لا يوجد شريك', 'm7md' ),
                'not_found_in_trash' => __( 'لا يوجد شريك', 'm7md' ),
                'parent_item_colon'  => ''
            ),
            'menu_icon'           => 'dashicons-admin-generic',
            'hierarchical'        => false,
            'public'              => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'menu_position'       => 6,
            'supports'            => array(
                'thumbnail',
                'title',
              //  'editor',
            //    'excerpt',
                //'tags',
            ),
            'query_var'           => true,
            'rewrite'             => array( 'slug' => 'partners' ),
        )
    );
}



// hook into the init action and call create_partners_taxonomies when it fires
//add_action( 'init', 'create_partners_taxonomies', 0 );
// create two taxonomies, genres and writers for the post type "prints"
function create_partners_taxonomies() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => __( 'أقسام شركاؤنا', 'm7md' ),
        'all_items'         => __( 'كافة الأقسام', 'm7md' ),
    );

    $args = array(
        'hierarchical'        => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'partnersCat' ),
    );

    register_taxonomy( 'partners_cat', array( 'partners' ), $args );
}
