<?php
/*************************************************************************************/
/* registering workfields post type.* /
/**************************************************************************************/
add_action( 'init', 'create_post_types_workfields' );

function create_post_types_workfields() {
    register_post_type( 'workfields', array(
            'labels'              => array(
                'name'               => __( 'مجالات العمل', 'm7md' ),
                'singular_name'      => __( 'مجالات العمل', 'm7md' ),
                'add_new'            => __( 'إضافة مجال', 'm7md' ),
                'add_new_item'       => __( 'مجال جديدة', 'm7md' ),
                'all_items'          => __( 'مجالات العمل', 'm7md' ),
                'edit_item'          => __( 'تحرير مجال', 'm7md' ),
                'new_item'           => __( 'مجال جديدة', 'm7md' ),
                'view_item'          => __( 'معاينة مجال', 'm7md' ),
                'search_items'       => __( 'البحث عن مجال', 'm7md' ),
                'not_found'          => __( 'لا يوجد مجال', 'm7md' ),
                'not_found_in_trash' => __( 'لا يوجد مجال', 'm7md' ),
                'parent_item_colon'  => ''
            ),
            'menu_icon'           => 'dashicons-admin-generic',
            'hierarchical'        => true,
            'public'              => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'menu_position'       => 7,
            'supports'            => array(
                'thumbnail',
                'title',
                 'editor',
                //'tags'
            ),
            'query_var'           => true,
            'rewrite'             => array( 'slug' => 'workfields' ),
        )
    );
}



//// hook into the init action and call create_workfields_taxonomies when it fires
 add_action( 'init', 'create_workfields_taxonomies', 0 );
// create two taxonomies, genres and writers for the post type "prints"
function create_workfields_taxonomies() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => __( 'أقسام مجالات العمل', 'm7md' ),
        'all_items'         => __( 'كافة الأقسام', 'm7md' ),
    );

    $args = array(
        'hierarchical'        => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'slid' ),
    );

    register_taxonomy( 'workfields_taxonomy', array( 'workfields' ), $args );
}
