<?php /*Template Name: cart */ ?>
<?php get_header(); ?>
<h1 class="pagetit text-center">
    <?php the_title(); ?>
</h1>
<script type="text/javascript">


    //window.location.href = '<?php  echo home_url() ?>';


</script>

<?php
global $wpdb;
$userid = get_current_user_id();
$courseid = get_the_ID();

$k = stripslashes($_COOKIE["cart"]);
$courses = json_decode($k);
$ids = [];
$total = [];
$totalprice = 0;
if ($courses):
    foreach ($courses as $course) :
        $ids[] = @$course->courseid;
        $total[] = @$course->price;
    endforeach;
    $totalprice = array_sum($total);
endif;
?>


<section class="content">
    <div class="container">


        <?php if ($courses) : ?>
            <div class="page-main">
                <?php
                $args = array(
                    'post_type' => 'courses',
                    'post__in' => $ids
                );
                $loop = new WP_Query($args);
                if ($loop->have_posts()) :
                    ?>
                    <div class="row">
                        <?php while ($loop->have_posts()) : $loop->the_post(); ?>
                            <div class="col-md-4">
                                <div class="course-item">
                                    <div class="course-item-thumb">
                                        <a href="<?php the_permalink(); ?>"
                                           title="<?php the_title(); ?>">
                                            <div class="event-img">
                                                <?php the_post_thumbnail('full', ['class' => 'img-fluid']); ?>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="course-item-body">
                                        <h4 class="course-item-tit">
                                            <a href="<?php the_permalink(); ?>"
                                               title="<?php the_title(); ?>">
                                                <?php the_title(); ?>
                                                <span class="price d-block">
                                            <?php the_field("course_price"); ?>
                                            <?php _e(' ر.س', 'm7md') ?>
                                           </span>
                                            </a>
                                        </h4>
                                        <div class="course-item-actions">
                                            <button class="removefromcart main-btn"
                                                    value="<?php the_ID(); ?>">
                                                <span> <?php _e(' حذف', 'm7md') ?></span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php endif; ?>


                <div class="totalprice">
                    <h2>
                        <?php _e('اجمالي التكلفة', 'm7md') ?> :
                        <span><?php echo $totalprice; ?><?php _e(' ر.س', 'm7md') ?></span>
                    </h2>
                </div>
                <div class="coubon">
                    <h2><?php _e('  كوبون خصم', 'm7md') ?> </h2>
                    <div class="form-group">
                        <input class="coup form-control"
                               type="text"
                               placeholder="<?php _e(' كوبون خصم', 'm7md') ?>">
                    </div>
                    <div class="end-cart-btn">
                        <button class="submitcode main-btn">
                            <span><?php _e('تطبيق الكوبون', 'm7md') ?></span>
                        </button>
                        <div class="endorder">
                            <?php if (is_user_logged_in()) :
                                ?>
                                <button id="endorder"
                                        class="main-btn">
                                    <span><?php _e('  انهاء الطلب', 'm7md') ?></span>
                                </button>
                            <?php else : ?>


                                <a class='main-button'
                                   href='<?php echo get_page_link(84); ?>'
                                   title='<?php the_title(); ?>'>
                                <span>
                                 <?php _e('تسجيل دخول', 'm7md') ?>
                               </span>
                                    <?php the_switch_language("<i class='fa-solid fa-arrow-left-long'></i>", "<i class='fa-solid fa-arrow-right-long'></i>") ?>
                                </a>

                            <?php endif; ?>
                        </div>
                    </div>

                </div>


            </div>

        <?php else:  ?>
            <div class="empty text-center">
                <h1><?php _e(' السلة فارغة', 'm7md') ?></h1>
            </div>
        <?php endif; ?>
    </div>
</section>


<?php get_footer(); ?>
<script>
    var myprice = null;
    var coup = null;
    jQuery('.submitcode').on('click', function () {
        var coubon = jQuery('.coup').val();
        if (coubon == null || coubon == undefined || coubon == "") {
            swal("يجب ادخال كود القسيمة", "", "error");
        } else {
            console.log(coubon)

            jQuery.ajax({
                type: 'POST',
                url: '<?php echo get_site_url()?>/wp-admin/admin-ajax.php',
                data: {
                    'action': 'applycode',
                    'coubon': coubon,
                    'totalprice':<?php echo $totalprice; ?>
                },
                success: function (data) {
                    var obj = jQuery.parseJSON(data);
                    if (obj['status'] == true) {
                        var per = obj['data'];
                        var price = <?php echo $totalprice; ?>;
                        var aftersale = (price - (price * per / 100)).toFixed();
                        jQuery(".totalprice span").html(aftersale + " ر.س ");
                        myprice = aftersale;
                        coup = coubon;
                        Swal.fire(obj['msg'], "", "success");
                    } else if (obj['status'] == 'price') {
                        Swal.fire("مرفوض", obj['msg'], "error");
                    } else {
                        Swal.fire(obj['msg'], "", "error");
                    }
                },
                error: function (data) {
                    console.log(data);
                }
            });
        }
    });
    jQuery('#endorder').on('click', function () {
        if (myprice == null || myprice == undefined || myprice == "") {
            var price = <?php echo $totalprice; ?>;
        } else {
            var price = myprice;
        }
          window.location = '<?php echo get_page_link(143); ?>/?&price=' + price + '&coup=' + coup


   /* jQuery.ajax({
            type: 'POST',
            url: '<?php echo get_site_url()?>/wp-admin/admin-ajax.php',
            data: {
                'action': 'tabbayment',
                'price':price,
                'coup':coup
            },
            success: function (data) {
                window.location = data;
            },
            error: function (data) {
                console.log(data);
            }
        });

*/
    });

</script>
