<?php /*Template Name: favourite */ ?>
<?php get_header(); ?>

<?php
global $wpdb;
$k = stripslashes($_COOKIE["favourit"]);
$courses = json_decode($k);
$ids = [];
if ($courses):
    foreach ($courses as $course) :
        $ids[] = $course->courseid;
    endforeach;
endif;
?>

<section class="content">
    <div class="container">
        <h1 class="sec-tit text-center">
            <?php the_title(); ?>
        </h1>

        <?php if ($courses) : ?>
            <div class="page-main">
                <?php
                $args = array(
                    'post_type' => 'courses',
                    'post__in' => $ids
                );
                $loop = new WP_Query($args);
                if ($loop->have_posts()) :
                    ?>
                    <div class="row">
                        <?php while ($loop->have_posts()) : $loop->the_post(); ?>
                            <div class="col-md-4">
                                <div class="course-item">
                                    <div class="course-item-thumb">
                                        <a href="<?php the_permalink(); ?>"
                                           title="<?php the_title(); ?>">
                                            <div class="event-img">
                                                <?php the_post_thumbnail('full', ['class' => 'img-fluid']); ?>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="course-item-body">
                                        <h4 class="course-item-tit">
                                            <a href="<?php the_permalink(); ?>"
                                               title="<?php the_title(); ?>">
                                                <?php the_title(); ?>
                                            </a>
                                        </h4>
                                    </div>
                                    <div class="course-item-actions">
                                        <button class="  addcart"
                                                value="<?php the_ID(); ?>">
                                            <i class="fas fa-shopping-cart"></i>
                                        </button>

                                        <button class="remfav  "
                                                value="<?php the_ID(); ?>">
                                            <span><?php _e('حذف', 'm7md') ?></span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="empty text-center">
                <h1><?php _e('المفضلة فارغة', 'm7md') ?></h1>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php get_footer(); ?>

