<?php /*Template Name: joinlectures  */ ?>
<?php get_header();

global $user_ID, $user_identity, $current_user;
get_currentuserinfo();
$current_user = wp_get_current_user();
$user_id = get_current_user_id();
$user_instructor = get_field('user_membership', 'user_' . $current_user->ID) == 'instructor';
$user_member = get_field('user_membership', 'user_' . $current_user->ID) == 'member';
$user_status_activate = get_field('user_status', 'user_' . $current_user->ID) == 'activate';
$user_status_deactivate = get_field('user_status', 'user_' . $current_user->ID) == 'deactivate';
if (!is_user_logged_in() || $user_instructor || $user_status_deactivate) {
    $home = esc_url(home_url(''));
    header("Location: $home");
    exit;
}
?>

<section class="content">
    <div class="container">
        <h1 class="sec-tit text-center">
            <?php the_title(); ?>
        </h1>

        <div class="page-main">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th scope="col"><?php _e('إسم الدرس', 'm7md') ?></th>
                        <th scope="col"><?php _e('المحاضر', 'm7md') ?></th>
                        <th scope="col"><?php _e('الثمن', 'm7md') ?></th>
                        <th scope="col"><?php _e('تاريخ الاشتراك', 'm7md') ?></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php
                    global $wpdb;
                    $regs = $wpdb->get_results("SELECT * FROM courses_paid WHERE userid = '" . $user_id . "'");
                    foreach ($regs as $reg):
                        $mypost = get_post($reg->coursid);
                        ?>
                        <tr>
                            <td>
                                <a href="<?php echo get_permalink($mypost->ID); ?>">
                                    <?php echo $mypost->post_title; ?>
                                </a>
                            </td>
                            <td>
                                <?php echo get_the_author_meta('nickname', $mypost->post_author) ?>
                            </td>
                            <td>
                                <?php if (get_field('course_cost', $reg->coursid) == 'course_free') :
                                    echo 'مجانا';
                                elseif (get_field('course_cost', $reg->coursid) == 'course_paid') :
                                    the_field('course_price', $reg->coursid);
                                endif; ?>
                            </td>
                            <td>
                                <?php echo $reg->created_at; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>


<?php get_footer(); ?>



