<?php /*Template Name: mylectures  */ ?>
<?php get_header();

global $user_ID, $user_identity, $current_user;
get_currentuserinfo();
$current_user = wp_get_current_user();
$user_id = get_current_user_id();
$user_instructor = get_field('user_membership', 'user_' . $current_user->ID) == 'instructor';
$user_member = get_field('user_membership', 'user_' . $current_user->ID) == 'member';
$user_status_activate = get_field('user_status', 'user_' . $current_user->ID) == 'activate';
$user_status_deactivate = get_field('user_status', 'user_' . $current_user->ID) == 'deactivate';
if (!is_user_logged_in() || $user_member) {
    $home = esc_url(home_url(''));
    header("Location: $home");
    exit;
}
?>
<section class="content">
    <div class="container">
        <h1 class="sec-tit text-center">
            <?php the_title();?>
        </h1>

        <div class="page-main">
            <?php if ($user_instructor && $user_status_activate): ?>
                <?php
                $args = array(
                    'post_type' => 'courses',
                    'posts_per_page' => 120,
                    'post_status' => 'any',
                    //'post_status'   => 'publish',
                    'author__in' => array($user_id)
                );
                $the_query = new WP_Query($args); ?>
                <?php if ($the_query->have_posts()) : ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th scope="col"><?php _e('إسم الدرس', 'm7md') ?></th>
                                <th scope="col"><?php _e('حالة الدرس', 'm7md') ?></th>
                                <th scope="col"><?php _e('عدد المشتركين', 'm7md') ?></th>
                                <th scope="col"><?php _e('تعديل الدرس', 'm7md') ?></th>
                                <th scope="col"><?php _e('مسح الدرس', 'm7md') ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php while ($the_query->have_posts()) : $the_query->the_post();
                                ?>
                                <tr>
                                    <th>
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </th>
                                    <td>
                                        <?php
                                        //echo get_post_status();
                                        if (get_post_status(get_the_ID()) == 'draft') {
                                            if (('ar' === $GLOBALS['q_config']['language'])) {
                                                echo 'لم يتم الموافقه علية';
                                            } else {
                                                echo 'It has not been approved';
                                            }
                                        } elseif (get_post_status(get_the_ID()) == 'publish') {
                                            if (('ar' === $GLOBALS['q_config']['language'])) {
                                                echo 'تم الموافقه علية';
                                            } else {
                                                echo 'It was approved';
                                            }
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        global $wpdb;
                                        $regs = $wpdb->get_results("SELECT * FROM courses_paid WHERE  coursid= '" . get_the_ID() . "'");
                                        echo count($regs);
                                        ?>
                                        <?php _e('مشترك', 'm7md') ?>

                                    </td>
                                    <td>
                                        <?php
                                        //echo get_post_status();
                                        if (get_post_status(get_the_ID()) == 'draft') {
                                            ?>

                                            <a href="<?php echo get_page_link(116); ?>?pid=<?php echo get_the_ID(); ?>">

                                                <i class="fas fa-edit"></i></a>

                                            <?php
                                        } elseif (get_post_status(get_the_ID()) == 'publish') {
                                            ?>
                                            <?php _e('لا يمكن التعديل', 'm7md') ?>
                                            <?php
                                        }
                                        ?>


                                    </td>
                                    <!--<td>-->
                                    <!--    <?php if ($post->post_author == $current_user->ID && count($regs) <= 0) { ?>-->
                                    <!--        <a onclick="return confirm('Are you SURE you want to delete this post?')"-->
                                    <!--           href="<?php echo get_delete_post_link(get_the_ID()) ?>">-->
                                    <!--            <i class="fas fa-trash"></i>-->
                                    <!--        </a>-->
                                    <!--    <?php } ?>-->
                                    <!--</td>-->
                                    <td>
<?php if ($post->post_author == $current_user->ID && count($regs) <= 0) { ?>
    <a onclick="debugDelete(<?php echo get_the_ID(); ?>); return false;" href="javascript:void(0);">
        <i class="fas fa-trash"></i>
    </a>
<?php } ?>
</td>
<script>
<?php 
$confirm_en = "Are you sure you want to delete this post?";
$confirm_ar = "هل أنت متأكد من حذف هذا البوست؟";
$current_lang = qtranxf_getLanguage(); // لو btp qTranslate-X
$confirm_msg = ($current_lang == 'en') ? $confirm_en : $confirm_ar;
?>
var confirmMsg = '<?php echo $confirm_msg; ?>';

function debugDelete(postId) {
    if (!confirm(confirmMsg)) return;

    
    jQuery.post(ajaxurl, {
        action: 'debug_delete_post',
        post_id: postId
    }, function(response) {
     //   console.log('النتيجة:', response);
      //  alert('النتيجة:\n' + JSON.stringify(response, null, 2));
        location.reload();
    }).fail(function() {
      //  alert('خطأ في الاتصال');
    });
}
</script>

                                </tr>
                            <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                     <div class="alert alert-primary alert-dismissible fade show" role="alert">
                    <strong> 
                    <?php _e("<!--:en--> You haven't added any courses yet. <!--:--><!--:ar-->لم تقم باضافة كورسات بعد  <!--:-->"); ?>

                    </strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <?php endif; ?>
            <?php elseif ($user_instructor && $user_status_deactivate): ?>
                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                    <strong><?php _e('انت مسجل فى الموقع كمحاضر وفى انتظار تفعيل عضويتك', 'm7md') ?></strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<?php get_footer(); ?>



