<?php
$args = array(
    'post_type' => 'faqs',
    'posts_per_page' => 6,
    'no_found_rows' => true,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) : ?>

    <!--  section accordion  -->
    <div class="accordion">
        <div class="container">
            <h2 class="sec-tit text-center">
                <?php _e('الأسئلة الشائعة', 'm7md') ?>
            </h2>
            <div class="row">
                <?php while ($loop->have_posts()) : $loop->the_post(); ?>
                <div class="col-lg-6 col-12">
                    <div class="set">
                        <a href="javascript:">
                            <?php the_title(); ?>
                            <i class="fa-solid fa-caret-down"></i>
                        </a>
                        <div class="accordion-content">
                            <p>
                                <?php echo(has_excerpt() ? get_the_excerpt() : get_excerpt('50')) ?>
                            </p>
                            <a class='main-button'
                               href='<?php the_permalink(); ?>'
                               title='<?php the_title(); ?>'>
                                <span><?php _e('اقرأ المزيد', 'm7md') ?></span>
                                <?php the_switch_language("<i class='fa-solid fa-arrow-left-long'></i>",
                                    "<i class='fa-solid fa-arrow-right-long'></i>") ?>
                            </a>
                        </div>
                    </div>
                </div>
<?php endwhile; ?>
            </div>
        </div>
    </div>
    <!--   //section accordion -->

<?php endif;
wp_reset_postdata(); ?>
