<?php
/**
 * Template Part: Featured Articles Grid
 * يعرض آخر 4 مقالات: بطاقة كبيرة على اليمين + 3 بطاقات صغيرة على اليسار
 * ضع هذا الملف داخل قالب الثيم واستدعيه حيث تريده.
 */

$args = array(
    'post_type' => 'post',
    'posts_per_page' => 4,
    'post_status' => 'publish',
    'ignore_sticky_posts' => 1,
    'orderby' => 'date',
    'order' => 'DESC',
);

$query = new WP_Query($args);
if (!$query->have_posts()) {
    wp_reset_postdata();
    return;
}

$posts = $query->posts;
if (empty($posts)) {
    wp_reset_postdata();
    return;
}

// نحافظ على rtl
?>
<div class="allblogw">


    <div class="container">
        <h2 class="sec-tit text-center">
            <?php _e('الاخبار', 'm7md') ?>
        </h2>

        <div class="fw-articles-grid"  >
            <?php
            // العنصر الكبير: أول مشاركة (إذا موجودة)
            $first = array_shift($posts); // يأخذ أول عنصر
            $first_id = $first->ID;
            $first_title = get_the_title($first_id);
            $first_link = get_permalink($first_id);
            $first_excerpt = wp_trim_words( get_the_excerpt($first_id) ? get_the_excerpt($first_id) : wp_strip_all_tags($first->post_content), 28, '...' );
            $first_thumb = get_the_post_thumbnail_url($first_id, 'large');
         //   if (!$first_thumb) $first_thumb = esc_url( get_template_directory_uri() . '/assets/images/placeholder-large.jpg' );
            $first_cats = get_the_category($first_id);
            $first_cat = !empty($first_cats) ? esc_html($first_cats[0]->name) : '';
            ?>
            <div class="fw-col fw-col-right wow fadeInUp">
                <!-- البطاقة الكبيرة على اليمين -->
                <article class="fw-big-card" role="article" aria-labelledby="fw-big-<?php echo $first_id; ?>">
                    <div class="fw-big-content">
                        <div class="blogdta">
                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M7.20801 1.802V4.50492" stroke="#597487" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M14.416 1.802V4.50492" stroke="#597487" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M3.15332 8.18994H18.4699" stroke="#597487" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M18.9207 7.65819V15.3165C18.9207 18.0194 17.5692 19.8213 14.4158 19.8213H7.208C4.05459 19.8213 2.70312 18.0194 2.70312 15.3165V7.65819C2.70312 4.95527 4.05459 3.15332 7.208 3.15332H14.4158C17.5692 3.15332 18.9207 4.95527 18.9207 7.65819Z" stroke="#597487" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M14.1409 12.3433H14.1489" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M14.1409 15.0462H14.1489" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M10.8078 12.3433H10.8159" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M10.8078 15.0462H10.8159" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M7.47288 12.3433H7.48097" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M7.47288 15.0462H7.48097" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                            <?php echo get_the_date('j F Y'); ?>
                        </div>
                        <h3 id="fw-big-<?php echo $first_id; ?>"><?php echo esc_html($first_title); ?></h3>
                        <p class="fw-big-excerpt"><?php echo esc_html($first_excerpt); ?></p>
                        <a class="fw-btn-more" href="<?php echo esc_url($first_link); ?>"><?php _e("<!--:en--> Read More<!--:--><!--:ar--> اقرأ المزيد<!--:-->"); ?></a>
                    </div>

                    <div class="fw-big-thumb">
                        <img src="<?php echo esc_url($first_thumb); ?>" alt="<?php echo esc_attr($first_title); ?>">
                        <?php if ($first_cat): ?>
                            <span class="fw-badge fw-badge-gold"><?php echo $first_cat; ?></span>
                        <?php endif; ?>
                    </div>
                </article>
            </div>
            <div class="fw-col fw-col-left">
                <!-- ثلاث بطاقات صغيرة (ستظهر في العمود الأيسر) -->
                <?php
                $i = 0;
                $dba = .2;
                foreach ($posts as $p) {
                    if ($i >= 3) break;
                    $pid = $p->ID;
                    $title = get_the_title($pid);
                    $link = get_permalink($pid);
                    $excerpt = wp_trim_words( get_the_excerpt($pid) ? get_the_excerpt($pid) : wp_strip_all_tags($p->post_content), 18, '...' );
                    $thumb = get_the_post_thumbnail_url($pid, 'medium');
                    if (!$thumb) $thumb = esc_url( get_template_directory_uri() . '/assets/images/placeholder-small.jpg' );
                    $cats = get_the_category($pid);
                    $cat_name = !empty($cats) ? esc_html($cats[0]->name) : '';
                    ?>
                    <article class="fw-small-card wow fadeInUp" role="article" aria-labelledby="fw-small-<?php echo $pid; ?>" data-wow-delay="<?php echo $dba; ?>s">
                        <a class="fw-small-thumb" href="<?php echo esc_url($link); ?>">
                            <img src="<?php echo esc_url($thumb); ?>" alt="<?php echo esc_attr($title); ?>">
                            <?php if ($cat_name): ?>
                                <span class="fw-badge fw-badge-small"><?php echo $cat_name; ?></span>
                            <?php endif; ?>
                        </a>
                        <div class="fw-small-meta">
                            <div class="blogdta">
                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7.20801 1.802V4.50492" stroke="#597487" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M14.416 1.802V4.50492" stroke="#597487" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M3.15332 8.18994H18.4699" stroke="#597487" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M18.9207 7.65819V15.3165C18.9207 18.0194 17.5692 19.8213 14.4158 19.8213H7.208C4.05459 19.8213 2.70312 18.0194 2.70312 15.3165V7.65819C2.70312 4.95527 4.05459 3.15332 7.208 3.15332H14.4158C17.5692 3.15332 18.9207 4.95527 18.9207 7.65819Z" stroke="#597487" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M14.1409 12.3433H14.1489" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M14.1409 15.0462H14.1489" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M10.8078 12.3433H10.8159" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M10.8078 15.0462H10.8159" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M7.47288 12.3433H7.48097" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M7.47288 15.0462H7.48097" stroke="#597487" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>

                                <?php echo get_the_date('j F Y'); ?>
                            </div>
                            <h4 id="fw-small-<?php echo $pid; ?>"><a href="<?php echo esc_url($link); ?>"><?php echo esc_html($title); ?></a></h4>

                            <a class="fw-read-link" href="<?php echo esc_url($link); ?>"><?php _e("<!--:en--> Read More<!--:--><!--:ar--> اقرأ المزيد<!--:-->"); ?></a>
                        </div>
                    </article>
                    <?php
                    $i++;
                    $dba+=.2;
                }
                ?>
            </div>
        </div>
        <div class=' d-flex justify-content-center mt-5 '>
            <a   class='main-button  ' href='<?php echo esc_url( get_page_link( 20167 ) ); ?>' title='<?php the_title(); ?>'>
                <span> <?php _e('عرض المزيد', 'm7md') ?></span>
                <?php the_switch_language("<i class='fa-solid fa-arrow-left-long'></i>", "<i class='fa-solid fa-arrow-right-long'></i>") ?>
            </a>
        </div>


    </div>
</div>

<?php wp_reset_postdata(); ?>
